<?php

namespace Database\Seeders;

use App\Models\UserEducation;
use App\Models\UserExperience;
use App\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $user = User::find(1);
        if ($user) {
            $user->special_commission = 100;
            $user->save();
        }

        $user = new User();
        $user->role_id = 2;
        $user->name = 'Teacher';
        $user->image = 'public/demo/user/' . 'instructor4.jpg';
        $user->email = 'teacher@infixlms.com';
        $user->username = 'teacher@infixlms.com';
        $user->headline = 'IT Specialist';
        $user->phone = '01711223345';
        $user->about = "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.";
        $user->short_details = "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.";

        $user->email_verified_at = now();
        $user->password = Hash::make('12345678');
        $user->created_at = date('Y-m-d h:i:s');
        $user->referral = Str::random(10);
        $user->about = "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.";
        $user->save();

        $user = new User();
        $user->role_id = 3;
        $user->name = 'Student';
        $user->email = 'student@infixlms.com';
        $user->username = 'student@infixlms.com';
        $user->headline = 'Student';
        $user->phone = '01711223346';
        $user->balance = 500;
        $user->about = "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.";
        $user->short_details = "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.";

        $user->email_verified_at = now();
        $user->password = Hash::make('12345678');
        $user->created_at = date('Y-m-d h:i:s');
        $user->referral = 123456;
        $user->save();


        \App\User::insert(
            ['name' => 'Robert Pattinson',
                'username' => 'instructor2',
                'role_id' => '2',
                'email' => 'instructor2@infixlms.com',
                'password' => bcrypt('12345678'),
                'email_verify' => 1,
                'email_verified_at' => now(),

                'currency_id' => 1,
                'headline' => 'Founder & CEO',
                'referral' => Str::random(10),
                'image' => 'public/demo/user/' . 'instructor1.jpg',
                'about' => 'Hi! This is Deniel. When you sign up, you’ll immediately have unlimited viewing of thousands of expert courses, paths to guide your learning, tools to measure your skills and hands-on resources like exercise files. There’s no limit on what you can learn and you can cancel at any time components, and storage devices. Finally, you’ll examine which printing technology addresses various needs and you’ll learn how to configure a multi-function printing device.',
            ]
        );

        \App\User::insert(

            ['name' => 'Johnny Depp',
                'username' => 'instructor3',
                'role_id' => '2',
                'email_verified_at' => now(),
                'email' => 'instructor3@infixlms.com',
                'password' => bcrypt('12345678'),
                'email_verify' => 1,
                'currency_id' => 1,
                'headline' => 'Account Officer',
                'referral' => Str::random(10),
                'image' => 'public/demo/user/' . 'instructor3.jpg',
                'about' => 'Hi! This is Deniel. When you sign up, you’ll immediately have unlimited viewing of thousands of expert courses, paths to guide your learning, tools to measure your skills and hands-on resources like exercise files. There’s no limit on what you can learn and you can cancel at any time components, and storage devices. Finally, you’ll examine which printing technology addresses various needs and you’ll learn how to configure a multi-function printing device.',
            ],

        );


        \App\User::insert(
            ['name' => 'Bradley Cooper',
                'username' => 'instructor4',
                'role_id' => '2',
                'email_verified_at' => now(),
                'email' => 'instructor4@infixlms.com',
                'password' => bcrypt('12345678'),
                'email_verify' => 1,
                'currency_id' => 1,
                'headline' => 'Creative Director',
                'referral' => Str::random(10),
                'image' => 'public/demo/user/' . 'instructor4.jpg',
                'about' => 'Hi! This is Deniel. When you sign up, you’ll immediately have unlimited viewing of thousands of expert courses, paths to guide your learning, tools to measure your skills and hands-on resources like exercise files. There’s no limit on what you can learn and you can cancel at any time components, and storage devices. Finally, you’ll examine which printing technology addresses various needs and you’ll learn how to configure a multi-function printing device.',
            ],
        );


        \App\User::insert(['name' => 'Carlie Jhovis',
            'username' => 'student2',
            'role_id' => '3',
            'email_verified_at' => now(),
            'email' => 'student2@infixlms.com',
            'password' => bcrypt('12345678'),
            'email_verify' => 1,
            'currency_id' => 1,
            'balance' => 500,
            'referral' => Str::random(10),
            'image' => 'public/demo/user/' . 'user.jpg',
            'about' => 'Hi! This is Deniel. When you sign up, you’ll immediately have unlimited viewing of thousands of expert courses, paths to guide your learning, tools to measure your skills and hands-on resources like exercise files. There’s no limit on what you can learn and you can cancel at any time components, and storage devices. Finally, you’ll examine which printing technology addresses various needs and you’ll learn how to configure a multi-function printing device.',
        ]);


        for ($i = 0; $i < 50; $i++) {
            \App\User::insert(
                ['name' => 'Instructor' . $i,
                    'username' => 'instructor4' . $i,
                    'role_id' => '2',
                    'email_verified_at' => now(),
                    'email' => 'instructor4' . $i . '@infixlms.com',
                    'password' => bcrypt('12345678'),
                    'email_verify' => 1,
                    'currency_id' => 1,
                    'headline' => 'Creative Director',
                    'referral' => Str::random(10),
                    'image' => 'public/demo/user/' . 'instructor4.jpg',
                    'about' => 'Hi! This is Deniel. When you sign up, you’ll immediately have unlimited viewing of thousands of expert courses, paths to guide your learning, tools to measure your skills and hands-on resources like exercise files. There’s no limit on what you can learn and you can cancel at any time components, and storage devices. Finally, you’ll examine which printing technology addresses various needs and you’ll learn how to configure a multi-function printing device.',
                ],
            );
        }

        for ($j = 0; $j < 50; $j++) {
            \App\User::insert(
                ['name' => 'Student' . $j,
                    'username' => 'Student1' . $j,
                    'role_id' => '3',
                    'email_verified_at' => now(),
                    'email' => 'student3' . $j . '@infixlms.com',
                    'password' => bcrypt('12345678'),
                    'email_verify' => 1,
                    'currency_id' => 1,
                    'headline' => 'Creative Director',
                    'referral' => Str::random(10),
                    'image' => 'public/demo/user/' . 'instructor4.jpg',
                    'about' => 'Hi! This is Deniel. When you sign up, you’ll immediately have unlimited viewing of thousands of expert courses, paths to guide your learning, tools to measure your skills and hands-on resources like exercise files. There’s no limit on what you can learn and you can cancel at any time components, and storage devices. Finally, you’ll examine which printing technology addresses various needs and you’ll learn how to configure a multi-function printing device.',
                ],
            );
        }
        $users = \App\User::all();
        foreach ($users as $user) {
            $user->job_title = $user->role->name;
            $user->save();

            UserEducation::create([
                'user_id' => $user->id,
                'institution' => 'Default Institution',
                'degree' => 'Default Degree',
                'start_date' => null,
                'end_date' => null,
            ]);

            UserExperience::create([
                'user_id' => $user->id,
                'title' => 'Default Job Title',
                'company_name' => 'Default Company',
                'currently_working' => true,
                'start_date' => now(),
                'end_date' => null,
            ]);
        }
    }
}
