<?php //af88023287364f7c4a3d2be237c10d84
/** @noinspection all */

namespace Modules\Quiz\Entities {

    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\AdvanceQuiz\Entities\_IH_OnlineQuizGroupAssign_C;
    use LaravelIdea\Helper\Modules\AdvanceQuiz\Entities\_IH_OnlineQuizGroupAssign_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Category_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_OnlineExamQuestionAssign_C;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_OnlineExamQuestionAssign_QB;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_OnlineQuiz_C;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_OnlineQuiz_QB;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuestionBankMuOption_C;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuestionBankMuOption_QB;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuestionBank_C;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuestionBank_QB;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuestionGroup_C;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuestionGroup_QB;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuestionLevel_C;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuestionLevel_QB;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuizeSetup_C;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuizeSetup_QB;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuizMarking_C;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuizMarking_QB;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuizTestDetailsAnswer_C;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuizTestDetailsAnswer_QB;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuizTestDetails_C;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuizTestDetails_QB;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuizTest_C;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_QuizTest_QB;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_StudentTakeOnlineQuiz_C;
    use LaravelIdea\Helper\Modules\Quiz\Entities\_IH_StudentTakeOnlineQuiz_QB;
    use Modules\AdvanceQuiz\Entities\OnlineQuizGroupAssign;
    use Modules\CourseSetting\Entities\Category;
    use Modules\CourseSetting\Entities\Course;
    
    /**
     * @property int $id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $online_exam_id
     * @property int|null $question_bank_id
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property QuestionBank|null $questionBank
     * @method BelongsTo|_IH_QuestionBank_QB questionBank()
     * @method static _IH_OnlineExamQuestionAssign_QB onWriteConnection()
     * @method _IH_OnlineExamQuestionAssign_QB newQuery()
     * @method static _IH_OnlineExamQuestionAssign_QB on(null|string $connection = null)
     * @method static _IH_OnlineExamQuestionAssign_QB query()
     * @method static _IH_OnlineExamQuestionAssign_QB with(array|string $relations)
     * @method _IH_OnlineExamQuestionAssign_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OnlineExamQuestionAssign_C|OnlineExamQuestionAssign[] all()
     * @ownLinks online_exam_id,\Modules\Quiz\Entities\OnlineQuiz,id|question_bank_id,\Modules\Quiz\Entities\QuestionBank,id
     * @mixin _IH_OnlineExamQuestionAssign_QB
     */
    class OnlineExamQuestionAssign extends Model {}
    
    /**
     * @property int $show_total_correct_answer
     * @property-read mixed[] $translations attribute
     * @property _IH_OnlineExamQuestionAssign_C|OnlineExamQuestionAssign[] $assign
     * @property-read int $assign_count
     * @method HasMany|_IH_OnlineExamQuestionAssign_QB assign()
     * @property _IH_Course_C|Course[] $assignCourses
     * @property-read int $assign_courses_count
     * @method HasMany|_IH_Course_QB assignCourses()
     * @property _IH_OnlineExamQuestionAssign_C|OnlineExamQuestionAssign[] $assignRand
     * @property-read int $assign_rand_count
     * @method HasMany|_IH_OnlineExamQuestionAssign_QB assignRand()
     * @property Category $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property QuestionGroup $group
     * @method BelongsTo|_IH_QuestionGroup_QB group()
     * @property _IH_OnlineQuizGroupAssign_C|OnlineQuizGroupAssign[] $group_assigns
     * @property-read int $group_assigns_count
     * @method HasMany|_IH_OnlineQuizGroupAssign_QB group_assigns()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_QuizTest_C|QuizTest[] $quizTests
     * @property-read int $quiz_tests_count
     * @method HasMany|_IH_QuizTest_QB quizTests()
     * @property Category $subCategory
     * @method BelongsTo|_IH_Category_QB subCategory()
     * @property _IH_OnlineExamQuestionAssign_C|OnlineExamQuestionAssign[] $totalMarks
     * @property-read int $total_marks_count
     * @method HasMany|_IH_OnlineExamQuestionAssign_QB totalMarks()
     * @property _IH_OnlineExamQuestionAssign_C|OnlineExamQuestionAssign[] $totalQuestions
     * @property-read int $total_questions_count
     * @method HasMany|_IH_OnlineExamQuestionAssign_QB totalQuestions()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_OnlineQuiz_QB onWriteConnection()
     * @method _IH_OnlineQuiz_QB newQuery()
     * @method static _IH_OnlineQuiz_QB on(null|string $connection = null)
     * @method static _IH_OnlineQuiz_QB query()
     * @method static _IH_OnlineQuiz_QB with(array|string $relations)
     * @method _IH_OnlineQuiz_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OnlineQuiz_C|OnlineQuiz[] all()
     * @mixin _IH_OnlineQuiz_QB
     */
    class OnlineQuiz extends Model {}
    
    /**
     * @property int $id
     * @property string $type
     * @property string|null $question
     * @property int|null $marks
     * @property string|null $trueFalse
     * @property string|null $suitable_words
     * @property string|null $number_of_option
     * @property int|null $q_group_id
     * @property int|null $category_id
     * @property int|null $sub_category_id
     * @property int $active_status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $user_id
     * @property string|null $image
     * @property string|null $explanation
     * @property int|null $level
     * @property int $pre_condition
     * @property int $number_of_qus
     * @property int $number_of_ans
     * @property string|null $connection
     * @property string|null $data
     * @property int $shuffle
     * @property Category|null $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property QuestionGroup|null $questionGroup
     * @method BelongsTo|_IH_QuestionGroup_QB questionGroup()
     * @property QuestionLevel|null $questionLevel
     * @method BelongsTo|_IH_QuestionLevel_QB questionLevel()
     * @property _IH_QuestionBankMuOption_C|QuestionBankMuOption[] $questionMu
     * @property-read int $question_mu_count
     * @method HasMany|_IH_QuestionBankMuOption_QB questionMu()
     * @property _IH_QuestionBankMuOption_C|QuestionBankMuOption[] $questionMuInSerial
     * @property-read int $question_mu_in_serial_count
     * @method HasMany|_IH_QuestionBankMuOption_QB questionMuInSerial()
     * @property _IH_OnlineExamQuestionAssign_C|OnlineExamQuestionAssign[] $quizAssign
     * @property-read int $quiz_assign_count
     * @method HasMany|_IH_OnlineExamQuestionAssign_QB quizAssign()
     * @property Category|null $subCategory
     * @method BelongsTo|_IH_Category_QB subCategory()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_QuestionBank_QB onWriteConnection()
     * @method _IH_QuestionBank_QB newQuery()
     * @method static _IH_QuestionBank_QB on(null|string $connection = null)
     * @method static _IH_QuestionBank_QB query()
     * @method static _IH_QuestionBank_QB with(array|string $relations)
     * @method _IH_QuestionBank_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_QuestionBank_C|QuestionBank[] all()
     * @ownLinks category_id,\Modules\CourseSetting\Entities\Category,id|sub_category_id,\Modules\CourseSetting\Entities\SubCategory,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @foreignLinks id,\Modules\Quiz\Entities\QuestionBankMuOption,question_bank_id|id,\Modules\Quiz\Entities\OnlineExamQuestionAssign,question_bank_id|id,\Modules\Survey\Entities\SurveyQuestionAssign,question_bank_id|id,\Modules\AdvanceQuiz\Entities\OnlineQuizCodeAssign,question_bank_id
     * @mixin _IH_QuestionBank_QB
     */
    class QuestionBank extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property int|null $status
     * @property int $active_status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $question_bank_id
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $type
     * @property int $option_index
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property QuestionBank|null $question
     * @method BelongsTo|_IH_QuestionBank_QB question()
     * @method static _IH_QuestionBankMuOption_QB onWriteConnection()
     * @method _IH_QuestionBankMuOption_QB newQuery()
     * @method static _IH_QuestionBankMuOption_QB on(null|string $connection = null)
     * @method static _IH_QuestionBankMuOption_QB query()
     * @method static _IH_QuestionBankMuOption_QB with(array|string $relations)
     * @method _IH_QuestionBankMuOption_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_QuestionBankMuOption_C|QuestionBankMuOption[] all()
     * @ownLinks question_bank_id,\Modules\Quiz\Entities\QuestionBank,id
     * @mixin _IH_QuestionBankMuOption_QB
     */
    class QuestionBankMuOption extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property int $active_status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $user_id
     * @property string|null $code
     * @property int $parent_id
     * @property int $order
     * @property int $level
     * @property _IH_QuestionGroup_C|QuestionGroup[] $childs
     * @property-read int $childs_count
     * @method HasMany|_IH_QuestionGroup_QB childs()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property QuestionGroup $parent
     * @method BelongsTo|_IH_QuestionGroup_QB parent()
     * @property _IH_QuestionBank_C|QuestionBank[] $questions
     * @property-read int $questions_count
     * @method HasMany|_IH_QuestionBank_QB questions()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_QuestionGroup_QB onWriteConnection()
     * @method _IH_QuestionGroup_QB newQuery()
     * @method static _IH_QuestionGroup_QB on(null|string $connection = null)
     * @method static _IH_QuestionGroup_QB query()
     * @method static _IH_QuestionGroup_QB with(array|string $relations)
     * @method _IH_QuestionGroup_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_QuestionGroup_C|QuestionGroup[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_QuestionGroup_QB
     */
    class QuestionGroup extends Model {}
    
    /**
     * @property int $id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $title
     * @property int $status
     * @property-read mixed[] $translations attribute
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_QuestionBank_C|QuestionBank[] $questions
     * @property-read int $questions_count
     * @method HasMany|_IH_QuestionBank_QB questions()
     * @property _IH_QuestionBank_C|QuestionBank[] $totalQuestions
     * @property-read int $total_questions_count
     * @method HasMany|_IH_QuestionBank_QB totalQuestions()
     * @method static _IH_QuestionLevel_QB onWriteConnection()
     * @method _IH_QuestionLevel_QB newQuery()
     * @method static _IH_QuestionLevel_QB on(null|string $connection = null)
     * @method static _IH_QuestionLevel_QB query()
     * @method static _IH_QuestionLevel_QB with(array|string $relations)
     * @method _IH_QuestionLevel_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_QuestionLevel_C|QuestionLevel[] all()
     * @mixin _IH_QuestionLevel_QB
     */
    class QuestionLevel extends Model {}
    
    /**
     * @property int $id
     * @property int|null $quiz_id
     * @property int|null $quiz_test_id
     * @property int|null $student_id
     * @property int|null $marked_by
     * @property int|null $marking_status
     * @property float|null $marks
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_QuizMarking_QB onWriteConnection()
     * @method _IH_QuizMarking_QB newQuery()
     * @method static _IH_QuizMarking_QB on(null|string $connection = null)
     * @method static _IH_QuizMarking_QB query()
     * @method static _IH_QuizMarking_QB with(array|string $relations)
     * @method _IH_QuizMarking_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_QuizMarking_C|QuizMarking[] all()
     * @ownLinks quiz_test_id,\Modules\Quiz\Entities\QuizTest,id
     * @mixin _IH_QuizMarking_QB
     */
    class QuizMarking extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int|null $course_id
     * @property int|null $quiz_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $pass
     * @property Carbon|null $start_at
     * @property Carbon|null $end_at
     * @property float|null $duration
     * @property int $publish
     * @property int $quiz_type
     * @property int $focus_lost
     * @property string|null $comment
     * @property int $warning
     * @property int $extra_time
     * @property int $continue_do_test
     * @property int $state
     * @property int $flag
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property _IH_QuizTestDetails_C|QuizTestDetails[] $details
     * @property-read int $details_count
     * @method HasMany|_IH_QuizTestDetails_QB details()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property OnlineQuiz|null $quiz
     * @method BelongsTo|_IH_OnlineQuiz_QB quiz()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_QuizTest_QB onWriteConnection()
     * @method _IH_QuizTest_QB newQuery()
     * @method static _IH_QuizTest_QB on(null|string $connection = null)
     * @method static _IH_QuizTest_QB query()
     * @method static _IH_QuizTest_QB with(array|string $relations)
     * @method _IH_QuizTest_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_QuizTest_C|QuizTest[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|course_id,\Modules\CourseSetting\Entities\Course,id
     * @foreignLinks id,\Modules\Quiz\Entities\QuizTestDetails,quiz_test_id|id,\Modules\Quiz\Entities\QuizMarking,quiz_test_id
     * @mixin _IH_QuizTest_QB
     */
    class QuizTest extends Model {}
    
    /**
     * @property int $id
     * @property int $quiz_test_id
     * @property int $qus_id
     * @property int|null $ans_id
     * @property int $status
     * @property int $mark
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $answer
     * @property _IH_QuizTestDetailsAnswer_C|QuizTestDetailsAnswer[] $answers
     * @property-read int $answers_count
     * @method HasMany|_IH_QuizTestDetailsAnswer_QB answers()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property QuestionBank $question
     * @method BelongsTo|_IH_QuestionBank_QB question()
     * @method static _IH_QuizTestDetails_QB onWriteConnection()
     * @method _IH_QuizTestDetails_QB newQuery()
     * @method static _IH_QuizTestDetails_QB on(null|string $connection = null)
     * @method static _IH_QuizTestDetails_QB query()
     * @method static _IH_QuizTestDetails_QB with(array|string $relations)
     * @method _IH_QuizTestDetails_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_QuizTestDetails_C|QuizTestDetails[] all()
     * @ownLinks quiz_test_id,\Modules\Quiz\Entities\QuizTest,id
     * @foreignLinks id,\Modules\Quiz\Entities\QuizTestDetailsAnswer,quiz_test_details_id
     * @mixin _IH_QuizTestDetails_QB
     */
    class QuizTestDetails extends Model {}
    
    /**
     * @property int $id
     * @property int $quiz_test_details_id
     * @property int $ans_id
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_QuizTestDetailsAnswer_QB onWriteConnection()
     * @method _IH_QuizTestDetailsAnswer_QB newQuery()
     * @method static _IH_QuizTestDetailsAnswer_QB on(null|string $connection = null)
     * @method static _IH_QuizTestDetailsAnswer_QB query()
     * @method static _IH_QuizTestDetailsAnswer_QB with(array|string $relations)
     * @method _IH_QuizTestDetailsAnswer_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_QuizTestDetailsAnswer_C|QuizTestDetailsAnswer[] all()
     * @ownLinks quiz_test_details_id,\Modules\Quiz\Entities\QuizTestDetails,id
     * @mixin _IH_QuizTestDetailsAnswer_QB
     */
    class QuizTestDetailsAnswer extends Model {}
    
    /**
     * @property int $show_total_correct_answer
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_QuizeSetup_QB onWriteConnection()
     * @method _IH_QuizeSetup_QB newQuery()
     * @method static _IH_QuizeSetup_QB on(null|string $connection = null)
     * @method static _IH_QuizeSetup_QB query()
     * @method static _IH_QuizeSetup_QB with(array|string $relations)
     * @method _IH_QuizeSetup_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_QuizeSetup_C|QuizeSetup[] all()
     * @mixin _IH_QuizeSetup_QB
     */
    class QuizeSetup extends Model {}
    
    /**
     * @property int $id
     * @property int $status
     * @property int|null $total_marks
     * @property int $active_status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $student_id
     * @property int|null $online_exam_id
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_StudentTakeOnlineQuiz_QB onWriteConnection()
     * @method _IH_StudentTakeOnlineQuiz_QB newQuery()
     * @method static _IH_StudentTakeOnlineQuiz_QB on(null|string $connection = null)
     * @method static _IH_StudentTakeOnlineQuiz_QB query()
     * @method static _IH_StudentTakeOnlineQuiz_QB with(array|string $relations)
     * @method _IH_StudentTakeOnlineQuiz_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_StudentTakeOnlineQuiz_C|StudentTakeOnlineQuiz[] all()
     * @ownLinks online_exam_id,\Modules\Quiz\Entities\OnlineQuiz,id
     * @mixin _IH_StudentTakeOnlineQuiz_QB
     */
    class StudentTakeOnlineQuiz extends Model {}
}