<?php //85cca6d8035478ccf815a2df2740b67b
/** @noinspection all */

namespace Modules\AIContent\Entities {

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\Modules\AIContent\Entities\_IH_AiGeneratedContent_C;
    use LaravelIdea\Helper\Modules\AIContent\Entities\_IH_AiGeneratedContent_QB;
    use LaravelIdea\Helper\Modules\AIContent\Entities\_IH_AITemplateContent_C;
    use LaravelIdea\Helper\Modules\AIContent\Entities\_IH_AITemplateContent_QB;
    use LaravelIdea\Helper\Modules\AIContent\Entities\_IH_AITemplate_C;
    use LaravelIdea\Helper\Modules\AIContent\Entities\_IH_AITemplate_QB;
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $slug
     * @property string|null $icon
     * @property int $type
     * @property int $status
     * @property int|null $created_by
     * @property int|null $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property AITemplateContent $template_content
     * @method BelongsTo|_IH_AITemplateContent_QB template_content()
     * @method static _IH_AITemplate_QB onWriteConnection()
     * @method _IH_AITemplate_QB newQuery()
     * @method static _IH_AITemplate_QB on(null|string $connection = null)
     * @method static _IH_AITemplate_QB query()
     * @method static _IH_AITemplate_QB with(array|string $relations)
     * @method _IH_AITemplate_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AITemplate_C|AITemplate[] all()
     * @mixin _IH_AITemplate_QB
     */
    class AITemplate extends Model {}
    
    /**
     * @property int $id
     * @property int|null $template_id
     * @property array|null $content
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property AITemplate|null $template
     * @method BelongsTo|_IH_AITemplate_QB template()
     * @method static _IH_AITemplateContent_QB onWriteConnection()
     * @method _IH_AITemplateContent_QB newQuery()
     * @method static _IH_AITemplateContent_QB on(null|string $connection = null)
     * @method static _IH_AITemplateContent_QB query()
     * @method static _IH_AITemplateContent_QB with(array|string $relations)
     * @method _IH_AITemplateContent_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AITemplateContent_C|AITemplateContent[] all()
     * @mixin _IH_AITemplateContent_QB
     */
    class AITemplateContent extends Model {}
    
    /**
     * @property int $id
     * @property int|null $user_id
     * @property string|null $input_text
     * @property string|null $output_text
     * @property string|null $model
     * @property int|null $tokens
     * @property int|null $template_id
     * @property int|null $words
     * @property int|null $temperature
     * @property int|null $frequency_penalty
     * @property string|null $lang
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property AITemplate|null $template
     * @method BelongsTo|_IH_AITemplate_QB template()
     * @method static _IH_AiGeneratedContent_QB onWriteConnection()
     * @method _IH_AiGeneratedContent_QB newQuery()
     * @method static _IH_AiGeneratedContent_QB on(null|string $connection = null)
     * @method static _IH_AiGeneratedContent_QB query()
     * @method static _IH_AiGeneratedContent_QB with(array|string $relations)
     * @method _IH_AiGeneratedContent_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AiGeneratedContent_C|AiGeneratedContent[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_AiGeneratedContent_QB
     */
    class AiGeneratedContent extends Model {}
}