<?php //d58b02e4eac4d79a56c8a8e9ff2f873f
/** @noinspection all */

namespace Modules\ELibrary\Entities {

    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\ELibrary\Entities\_IH_EbookAccess_C;
    use LaravelIdea\Helper\Modules\ELibrary\Entities\_IH_EbookAccess_QB;
    use LaravelIdea\Helper\Modules\ELibrary\Entities\_IH_Ebook_C;
    use LaravelIdea\Helper\Modules\ELibrary\Entities\_IH_Ebook_QB;
    use LaravelIdea\Helper\Modules\Group\Entities\_IH_Group_QB;
    use LaravelIdea\Helper\Modules\MyClass\Entities\_IH_LmsClass_QB;
    use Modules\CourseSetting\Entities\Course;
    use Modules\Group\Entities\Group;
    use Modules\MyClass\Entities\LmsClass;
    
    /**
     * @property int $id
     * @property string|null $name
     * @property string|null $file_name
     * @property string|null $file
     * @property string|null $thumbnail
     * @property string|null $book_number
     * @property string|null $isbn_no
     * @property string|null $publisher_name
     * @property string|null $author_name
     * @property int|null $created_by
     * @property int|null $subscription
     * @property int|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_EbookAccess_C|EbookAccess[] $access
     * @property-read int $access_count
     * @method HasMany|_IH_EbookAccess_QB access()
     * @property EbookAccess $accessType
     * @method HasOne|_IH_EbookAccess_QB accessType()
     * @property EbookAccess $accessTypeAllStudent
     * @method HasOne|_IH_EbookAccess_QB accessTypeAllStudent()
     * @property EbookAccess $accessTypeClass
     * @method HasOne|_IH_EbookAccess_QB accessTypeClass()
     * @property EbookAccess $accessTypeCourse
     * @method HasOne|_IH_EbookAccess_QB accessTypeCourse()
     * @property EbookAccess $accessTypeGroup
     * @method HasOne|_IH_EbookAccess_QB accessTypeGroup()
     * @property User|null $userInfo
     * @method BelongsTo|_IH_User_QB userInfo()
     * @method static _IH_Ebook_QB onWriteConnection()
     * @method _IH_Ebook_QB newQuery()
     * @method static _IH_Ebook_QB on(null|string $connection = null)
     * @method static _IH_Ebook_QB query()
     * @method static _IH_Ebook_QB with(array|string $relations)
     * @method _IH_Ebook_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Ebook_C|Ebook[] all()
     * @foreignLinks id,\Modules\ELibrary\Entities\EbookAccess,ebook_id|id,\Modules\Membership\Entities\AddEbookToPlan,ebook_id|id,\Modules\Membership\Entities\EbookPlanEbook,ebook_id
     * @mixin _IH_Ebook_QB
     */
    class Ebook extends Model {}
    
    /**
     * @property int $id
     * @property string $type
     * @property int $ebook_id
     * @property int|null $group_id
     * @property int|null $class_id
     * @property int|null $course_id
     * @property int|null $created_by
     * @property int|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsClass|null $class
     * @method BelongsTo|_IH_LmsClass_QB class()
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property Group|null $group
     * @method BelongsTo|_IH_Group_QB group()
     * @method static _IH_EbookAccess_QB onWriteConnection()
     * @method _IH_EbookAccess_QB newQuery()
     * @method static _IH_EbookAccess_QB on(null|string $connection = null)
     * @method static _IH_EbookAccess_QB query()
     * @method static _IH_EbookAccess_QB with(array|string $relations)
     * @method _IH_EbookAccess_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EbookAccess_C|EbookAccess[] all()
     * @ownLinks ebook_id,\Modules\ELibrary\Entities\Ebook,id|group_id,\Modules\Group\Entities\Group,id|course_id,\Modules\CourseSetting\Entities\Course,id
     * @mixin _IH_EbookAccess_QB
     */
    class EbookAccess extends Model {}
}