<?php //c56766db54f09bdeb1e61d31926039fc
/** @noinspection all */

namespace Modules\Setting\Entities {

    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_Badge_C;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_Badge_QB;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_CookieSetting_C;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_CookieSetting_QB;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_ErrorLog_C;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_ErrorLog_QB;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_InstructorSetup_C;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_InstructorSetup_QB;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_IpBlock_C;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_IpBlock_QB;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_PayoutAccountSpecification_C;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_PayoutAccountSpecification_QB;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_PayoutAccount_C;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_PayoutAccount_QB;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_SmsGatewayParameter_C;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_SmsGatewayParameter_QB;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_SmsGateway_C;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_SmsGateway_QB;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_StudentSetup_C;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_StudentSetup_QB;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_UserBadge_C;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_UserBadge_QB;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_UserGamificationPoint_C;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_UserGamificationPoint_QB;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_UserLevelHistory_C;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_UserLevelHistory_QB;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_UserPayoutAccountSpecification_C;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_UserPayoutAccountSpecification_QB;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_UserPayoutAccount_C;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_UserPayoutAccount_QB;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_VersionHistory_C;
    use LaravelIdea\Helper\Modules\Setting\Entities\_IH_VersionHistory_QB;
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $type
     * @property string|null $image
     * @property int $point
     * @property int $status
     * @property Carbon $created_at
     * @property Carbon $updated_at
     * @method static _IH_Badge_QB onWriteConnection()
     * @method _IH_Badge_QB newQuery()
     * @method static _IH_Badge_QB on(null|string $connection = null)
     * @method static _IH_Badge_QB query()
     * @method static _IH_Badge_QB with(array|string $relations)
     * @method _IH_Badge_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Badge_C|Badge[] all()
     * @foreignLinks id,\Modules\Setting\Entities\UserBadge,badge_id
     * @mixin _IH_Badge_QB
     */
    class Badge extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $details
     * @property string $btn_text
     * @property string $text_color
     * @property string $bg_color
     * @property bool $allow
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string $image
     * @property string|null $customize_btn_text
     * @property string|null $gdpr_details
     * @property string|null $gdpr_strictly
     * @property string|null $gdpr_performance
     * @property string|null $gdpr_functional
     * @property string|null $gdpr_targeting
     * @property string|null $gdpr_confirm_choice_btn_text
     * @property string|null $gdpr_accept_all_btn_text
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_CookieSetting_QB onWriteConnection()
     * @method _IH_CookieSetting_QB newQuery()
     * @method static _IH_CookieSetting_QB on(null|string $connection = null)
     * @method static _IH_CookieSetting_QB query()
     * @method static _IH_CookieSetting_QB with(array|string $relations)
     * @method _IH_CookieSetting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CookieSetting_C|CookieSetting[] all()
     * @mixin _IH_CookieSetting_QB
     */
    class CookieSetting extends Model {}
    
    /**
     * @property int $id
     * @property string|null $subject
     * @property int $type
     * @property string|null $url
     * @property string|null $ip
     * @property string|null $agent
     * @property int|null $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_ErrorLog_QB onWriteConnection()
     * @method _IH_ErrorLog_QB newQuery()
     * @method static _IH_ErrorLog_QB on(null|string $connection = null)
     * @method static _IH_ErrorLog_QB query()
     * @method static _IH_ErrorLog_QB with(array|string $relations)
     * @method _IH_ErrorLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ErrorLog_C|ErrorLog[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_ErrorLog_QB
     */
    class ErrorLog extends Model {}
    
    /**
     * @property int $id
     * @property int|null $show_instructor_page_banner
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_InstructorSetup_QB onWriteConnection()
     * @method _IH_InstructorSetup_QB newQuery()
     * @method static _IH_InstructorSetup_QB on(null|string $connection = null)
     * @method static _IH_InstructorSetup_QB query()
     * @method static _IH_InstructorSetup_QB with(array|string $relations)
     * @method _IH_InstructorSetup_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstructorSetup_C|InstructorSetup[] all()
     * @mixin _IH_InstructorSetup_QB
     */
    class InstructorSetup extends Model {}
    
    /**
     * @property int $id
     * @property string $ip_address
     * @property string|null $reason
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_IpBlock_QB onWriteConnection()
     * @method _IH_IpBlock_QB newQuery()
     * @method static _IH_IpBlock_QB on(null|string $connection = null)
     * @method static _IH_IpBlock_QB query()
     * @method static _IH_IpBlock_QB with(array|string $relations)
     * @method _IH_IpBlock_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_IpBlock_C|IpBlock[] all()
     * @mixin _IH_IpBlock_QB
     */
    class IpBlock extends Model {}
    
    /**
     * @property int $id
     * @property string|null $logo
     * @property string|null $title
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_PayoutAccountSpecification_C|PayoutAccountSpecification[] $specifications
     * @property-read int $specifications_count
     * @method HasMany|_IH_PayoutAccountSpecification_QB specifications()
     * @method static _IH_PayoutAccount_QB onWriteConnection()
     * @method _IH_PayoutAccount_QB newQuery()
     * @method static _IH_PayoutAccount_QB on(null|string $connection = null)
     * @method static _IH_PayoutAccount_QB query()
     * @method static _IH_PayoutAccount_QB with(array|string $relations)
     * @method _IH_PayoutAccount_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PayoutAccount_C|PayoutAccount[] all()
     * @foreignLinks id,\Modules\Setting\Entities\PayoutAccountSpecification,payout_accounts_id|id,\Modules\Setting\Entities\UserPayoutAccount,payout_accounts_id|id,\Modules\Setting\Entities\UserPayoutAccountSpecification,payout_accounts_id
     * @mixin _IH_PayoutAccount_QB
     */
    class PayoutAccount extends Model {}
    
    /**
     * @property int $id
     * @property int $payout_accounts_id
     * @property string|null $title
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PayoutAccountSpecification_QB onWriteConnection()
     * @method _IH_PayoutAccountSpecification_QB newQuery()
     * @method static _IH_PayoutAccountSpecification_QB on(null|string $connection = null)
     * @method static _IH_PayoutAccountSpecification_QB query()
     * @method static _IH_PayoutAccountSpecification_QB with(array|string $relations)
     * @method _IH_PayoutAccountSpecification_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PayoutAccountSpecification_C|PayoutAccountSpecification[] all()
     * @ownLinks payout_accounts_id,\Modules\Setting\Entities\PayoutAccount,id
     * @mixin _IH_PayoutAccountSpecification_QB
     */
    class PayoutAccountSpecification extends Model {}
    
    /**
     * @property int $id
     * @property string|null $gateway_name
     * @property string|null $gateway_url
     * @property string|null $request_method
     * @property string|null $set_auth
     * @property string|null $send_to_parameter_name
     * @property string|null $message_to_parameter_name
     * @property string|null $gateway_logo
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $add_plus
     * @property _IH_SmsGatewayParameter_C|SmsGatewayParameter[] $params
     * @property-read int $params_count
     * @method HasMany|_IH_SmsGatewayParameter_QB params()
     * @method static _IH_SmsGateway_QB onWriteConnection()
     * @method _IH_SmsGateway_QB newQuery()
     * @method static _IH_SmsGateway_QB on(null|string $connection = null)
     * @method static _IH_SmsGateway_QB query()
     * @method static _IH_SmsGateway_QB with(array|string $relations)
     * @method _IH_SmsGateway_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SmsGateway_C|SmsGateway[] all()
     * @foreignLinks id,\Modules\Setting\Entities\SmsGatewayParameter,gateway_id
     * @mixin _IH_SmsGateway_QB
     */
    class SmsGateway extends Model {}
    
    /**
     * @property int $id
     * @property int $gateway_id
     * @property string|null $key
     * @property string|null $value
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SmsGatewayParameter_QB onWriteConnection()
     * @method _IH_SmsGatewayParameter_QB newQuery()
     * @method static _IH_SmsGatewayParameter_QB on(null|string $connection = null)
     * @method static _IH_SmsGatewayParameter_QB query()
     * @method static _IH_SmsGatewayParameter_QB with(array|string $relations)
     * @method _IH_SmsGatewayParameter_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SmsGatewayParameter_C|SmsGatewayParameter[] all()
     * @ownLinks gateway_id,\Modules\Setting\Model\SmsGateway,id
     * @mixin _IH_SmsGatewayParameter_QB
     */
    class SmsGatewayParameter extends Model {}
    
    /**
     * @property int $id
     * @property int|null $show_recommended_section
     * @property int|null $show_running_course_thumb
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_StudentSetup_QB onWriteConnection()
     * @method _IH_StudentSetup_QB newQuery()
     * @method static _IH_StudentSetup_QB on(null|string $connection = null)
     * @method static _IH_StudentSetup_QB query()
     * @method static _IH_StudentSetup_QB with(array|string $relations)
     * @method _IH_StudentSetup_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_StudentSetup_C|StudentSetup[] all()
     * @mixin _IH_StudentSetup_QB
     */
    class StudentSetup extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $badge_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $status
     * @property Badge $badge
     * @method BelongsTo|_IH_Badge_QB badge()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_UserBadge_QB onWriteConnection()
     * @method _IH_UserBadge_QB newQuery()
     * @method static _IH_UserBadge_QB on(null|string $connection = null)
     * @method static _IH_UserBadge_QB query()
     * @method static _IH_UserBadge_QB with(array|string $relations)
     * @method _IH_UserBadge_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserBadge_C|UserBadge[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|badge_id,\Modules\Setting\Entities\Badge,id
     * @mixin _IH_UserBadge_QB
     */
    class UserBadge extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string|null $type
     * @property string|null $badge_type
     * @property int $point
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_UserGamificationPoint_QB onWriteConnection()
     * @method _IH_UserGamificationPoint_QB newQuery()
     * @method static _IH_UserGamificationPoint_QB on(null|string $connection = null)
     * @method static _IH_UserGamificationPoint_QB query()
     * @method static _IH_UserGamificationPoint_QB with(array|string $relations)
     * @method _IH_UserGamificationPoint_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserGamificationPoint_C|UserGamificationPoint[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_UserGamificationPoint_QB
     */
    class UserGamificationPoint extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string|null $type
     * @property int $count
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_UserLevelHistory_QB onWriteConnection()
     * @method _IH_UserLevelHistory_QB newQuery()
     * @method static _IH_UserLevelHistory_QB on(null|string $connection = null)
     * @method static _IH_UserLevelHistory_QB query()
     * @method static _IH_UserLevelHistory_QB with(array|string $relations)
     * @method _IH_UserLevelHistory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserLevelHistory_C|UserLevelHistory[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_UserLevelHistory_QB
     */
    class UserLevelHistory extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $payout_accounts_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property PayoutAccount $payoutAccount
     * @method BelongsTo|_IH_PayoutAccount_QB payoutAccount()
     * @method static _IH_UserPayoutAccount_QB onWriteConnection()
     * @method _IH_UserPayoutAccount_QB newQuery()
     * @method static _IH_UserPayoutAccount_QB on(null|string $connection = null)
     * @method static _IH_UserPayoutAccount_QB query()
     * @method static _IH_UserPayoutAccount_QB with(array|string $relations)
     * @method _IH_UserPayoutAccount_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserPayoutAccount_C|UserPayoutAccount[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|payout_accounts_id,\Modules\Setting\Entities\PayoutAccount,id
     * @mixin _IH_UserPayoutAccount_QB
     */
    class UserPayoutAccount extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int|null $payout_accounts_id
     * @property int $specification_id
     * @property string $value
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property PayoutAccountSpecification $specification
     * @method BelongsTo|_IH_PayoutAccountSpecification_QB specification()
     * @method static _IH_UserPayoutAccountSpecification_QB onWriteConnection()
     * @method _IH_UserPayoutAccountSpecification_QB newQuery()
     * @method static _IH_UserPayoutAccountSpecification_QB on(null|string $connection = null)
     * @method static _IH_UserPayoutAccountSpecification_QB query()
     * @method static _IH_UserPayoutAccountSpecification_QB with(array|string $relations)
     * @method _IH_UserPayoutAccountSpecification_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserPayoutAccountSpecification_C|UserPayoutAccountSpecification[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|payout_accounts_id,\Modules\Setting\Entities\PayoutAccount,id
     * @mixin _IH_UserPayoutAccountSpecification_QB
     */
    class UserPayoutAccountSpecification extends Model {}
    
    /**
     * @property int $id
     * @property string|null $version
     * @property string|null $release_date
     * @property string|null $url
     * @property string|null $notes
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $migrations
     * @method static _IH_VersionHistory_QB onWriteConnection()
     * @method _IH_VersionHistory_QB newQuery()
     * @method static _IH_VersionHistory_QB on(null|string $connection = null)
     * @method static _IH_VersionHistory_QB query()
     * @method static _IH_VersionHistory_QB with(array|string $relations)
     * @method _IH_VersionHistory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_VersionHistory_C|VersionHistory[] all()
     * @mixin _IH_VersionHistory_QB
     */
    class VersionHistory extends Model {}
}