<?php //9b879862454b8340e566d49d4a6748f5
/** @noinspection all */

namespace Modules\RolePermission\Entities {

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\Modules\RolePermission\Entities\_IH_Permission_C;
    use LaravelIdea\Helper\Modules\RolePermission\Entities\_IH_Permission_QB;
    use LaravelIdea\Helper\Modules\RolePermission\Entities\_IH_RolePermission_C;
    use LaravelIdea\Helper\Modules\RolePermission\Entities\_IH_RolePermission_QB;
    use LaravelIdea\Helper\Modules\RolePermission\Entities\_IH_Role_C;
    use LaravelIdea\Helper\Modules\RolePermission\Entities\_IH_Role_QB;
    
    /**
     * @property int $id
     * @property int|null $module_id
     * @property int|null $parent_id
     * @property string|null $name
     * @property string|null $route
     * @property int $status
     * @property int $created_by
     * @property int $updated_by
     * @property int|null $type
     * @property int $backend
     * @property int $power
     * @property string|null $parent_route
     * @property int $ecommerce
     * @property string $icon
     * @property int $menu_status
     * @property string|null $old_name
     * @property int|null $old_type
     * @property string|null $old_parent_route
     * @property int $position
     * @property string|null $module
     * @property string|null $theme
     * @property string|null $not_module
     * @property string|null $not_theme
     * @property int $section_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property _IH_RolePermission_C|RolePermission[] $assign
     * @property-read int $assign_count
     * @method HasMany|_IH_RolePermission_QB assign()
     * @property _IH_Permission_C|Permission[] $childs
     * @property-read int $childs_count
     * @method HasMany|_IH_Permission_QB childs()
     * @property Permission|null $parent
     * @method BelongsTo|_IH_Permission_QB parent()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method BelongsToMany|_IH_Role_QB roles()
     * @method static _IH_Permission_QB onWriteConnection()
     * @method _IH_Permission_QB newQuery()
     * @method static _IH_Permission_QB on(null|string $connection = null)
     * @method static _IH_Permission_QB query()
     * @method static _IH_Permission_QB with(array|string $relations)
     * @method _IH_Permission_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Permission_C|Permission[] all()
     * @mixin _IH_Permission_QB
     */
    class Permission extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $type
     * @property string|null $details
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method BelongsToMany|_IH_Permission_QB permissions()
     * @method static _IH_Role_QB onWriteConnection()
     * @method _IH_Role_QB newQuery()
     * @method static _IH_Role_QB on(null|string $connection = null)
     * @method static _IH_Role_QB query()
     * @method static _IH_Role_QB with(array|string $relations)
     * @method _IH_Role_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Role_C|Role[] all()
     * @foreignLinks id,\PragmaRX\Google2FALaravel\Tests\Support\User,role_id|id,\Modules\OfflinePayment\Entities\OfflinePayment,role_id|id,\Modules\RolePermission\Entities\RolePermission,role_id|id,\Modules\HumanResource\Entities\LeaveDefine,role_id|id,\Modules\HumanResource\Entities\Attendance,role_id|id,\Modules\HumanResource\Entities\Payroll,role_id|id,\Modules\Coupons\Entities\UserWiseCouponSetting,role_id|id,\Modules\Homework\Entities\InfixHomework,role_id|id,\Modules\Homework\Entities\InfixSubmitHomework,role_id|id,\Modules\NotificationSetup\Entities\RoleEmailTemplate,role_id|id,\Modules\Survey\Entities\Survey,role_id|id,\Modules\UserType\Entities\UserRole,role_id|id,\Modules\Noticeboard\Entities\NoticeboardAssign,role_id
     * @mixin _IH_Role_QB
     */
    class Role extends Model {}
    
    /**
     * @property int $id
     * @property int|null $permission_id
     * @property int|null $role_id
     * @property bool $status
     * @property int $created_by
     * @property int $updated_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $policy_id
     * @property Permission|null $permission
     * @method BelongsTo|_IH_Permission_QB permission()
     * @method static _IH_RolePermission_QB onWriteConnection()
     * @method _IH_RolePermission_QB newQuery()
     * @method static _IH_RolePermission_QB on(null|string $connection = null)
     * @method static _IH_RolePermission_QB query()
     * @method static _IH_RolePermission_QB with(array|string $relations)
     * @method _IH_RolePermission_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RolePermission_C|RolePermission[] all()
     * @ownLinks permission_id,\Modules\RolePermission\Entities\Permission,id|role_id,\Modules\RolePermission\Entities\Role,id
     * @mixin _IH_RolePermission_QB
     */
    class RolePermission extends Model {}
}