<?php //a6b548c94880c658f8aecaa68bc56a47
/** @noinspection all */

namespace Modules\SystemSetting\Entities {

    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_Payroll_C;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_Payroll_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_AllLanguage_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_AllLanguage_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Currency_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Currency_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Department_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Department_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_EmailSetting_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_EmailSetting_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_EmailTemplate_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_EmailTemplate_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Faq_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Faq_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Feature_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Feature_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_FooterCategory_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_FooterCategory_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_FooterContent_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_FooterContent_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_FrontendSetting_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_FrontendSetting_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_LanguagePhase_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_LanguagePhase_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Message_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Message_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Modules_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Modules_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Page_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Page_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_SocialLink_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_SocialLink_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_StaffDocument_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_StaffDocument_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Staff_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Staff_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Testimonial_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_Testimonial_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_TimeZone_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_TimeZone_QB;
    use Modules\HumanResource\Entities\Payroll;
    
    /**
     * @method static _IH_AllLanguage_QB onWriteConnection()
     * @method _IH_AllLanguage_QB newQuery()
     * @method static _IH_AllLanguage_QB on(null|string $connection = null)
     * @method static _IH_AllLanguage_QB query()
     * @method static _IH_AllLanguage_QB with(array|string $relations)
     * @method _IH_AllLanguage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AllLanguage_C|AllLanguage[] all()
     * @mixin _IH_AllLanguage_QB
     */
    class AllLanguage extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property string|null $code
     * @property string|null $symbol
     * @property float $conversion_rate
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User $user
     * @method HasOne|_IH_User_QB user()
     * @method static _IH_Currency_QB onWriteConnection()
     * @method _IH_Currency_QB newQuery()
     * @method static _IH_Currency_QB on(null|string $connection = null)
     * @method static _IH_Currency_QB query()
     * @method static _IH_Currency_QB with(array|string $relations)
     * @method _IH_Currency_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Currency_C|Currency[] all()
     * @foreignLinks id,\PragmaRX\Google2FALaravel\Tests\Support\User,currency_id
     * @mixin _IH_Currency_QB
     */
    class Currency extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $details
     * @property string|null $user_id
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $lms_id
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property Staff|null $staff
     * @method BelongsTo|_IH_Staff_QB staff()
     * @method static _IH_Department_QB onWriteConnection()
     * @method _IH_Department_QB newQuery()
     * @method static _IH_Department_QB on(null|string $connection = null)
     * @method static _IH_Department_QB query()
     * @method static _IH_Department_QB with(array|string $relations)
     * @method _IH_Department_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Department_C|Department[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_Department_QB
     */
    class Department extends Model {}
    
    /**
     * @property int $id
     * @property string|null $email_engine_type
     * @property string|null $from_name
     * @property string|null $from_email
     * @property string|null $mail_driver
     * @property string|null $mail_host
     * @property string|null $mail_port
     * @property string|null $mail_username
     * @property string|null $mail_password
     * @property string|null $mail_encryption
     * @property int $active_status
     * @property string|null $api_key
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_EmailSetting_QB onWriteConnection()
     * @method _IH_EmailSetting_QB newQuery()
     * @method static _IH_EmailSetting_QB on(null|string $connection = null)
     * @method static _IH_EmailSetting_QB query()
     * @method static _IH_EmailSetting_QB with(array|string $relations)
     * @method _IH_EmailSetting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EmailSetting_C|EmailSetting[] all()
     * @mixin _IH_EmailSetting_QB
     */
    class EmailSetting extends Model {}
    
    /**
     * @property string|null $sms_message
     * @method static _IH_EmailTemplate_QB onWriteConnection()
     * @method _IH_EmailTemplate_QB newQuery()
     * @method static _IH_EmailTemplate_QB on(null|string $connection = null)
     * @method static _IH_EmailTemplate_QB query()
     * @method static _IH_EmailTemplate_QB with(array|string $relations)
     * @method _IH_EmailTemplate_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EmailTemplate_C|EmailTemplate[] all()
     * @mixin _IH_EmailTemplate_QB
     */
    class EmailTemplate extends Model {}
    
    /**
     * @property int $id
     * @property string|null $question
     * @property string|null $answer
     * @property int $status
     * @property int $order
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $added_format attribute
     * @method static _IH_Faq_QB onWriteConnection()
     * @method _IH_Faq_QB newQuery()
     * @method static _IH_Faq_QB on(null|string $connection = null)
     * @method static _IH_Faq_QB query()
     * @method static _IH_Faq_QB with(array|string $relations)
     * @method _IH_Faq_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Faq_C|Faq[] all()
     * @mixin _IH_Faq_QB
     */
    class Faq extends Model {}
    
    /**
     * @method static _IH_Feature_QB onWriteConnection()
     * @method _IH_Feature_QB newQuery()
     * @method static _IH_Feature_QB on(null|string $connection = null)
     * @method static _IH_Feature_QB query()
     * @method static _IH_Feature_QB with(array|string $relations)
     * @method _IH_Feature_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Feature_C|Feature[] all()
     * @mixin _IH_Feature_QB
     */
    class Feature extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $description
     * @property string|null $placeholder
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_FooterContent_C|FooterContent[] $contents
     * @property-read int $contents_count
     * @method HasMany|_IH_FooterContent_QB contents()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_FooterCategory_QB onWriteConnection()
     * @method _IH_FooterCategory_QB newQuery()
     * @method static _IH_FooterCategory_QB on(null|string $connection = null)
     * @method static _IH_FooterCategory_QB query()
     * @method static _IH_FooterCategory_QB with(array|string $relations)
     * @method _IH_FooterCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_FooterCategory_C|FooterCategory[] all()
     * @foreignLinks id,\Modules\SystemSetting\Entities\FooterContent,footer_category_id
     * @mixin _IH_FooterCategory_QB
     */
    class FooterCategory extends Model {}
    
    /**
     * @property int $id
     * @property int $footer_category_id
     * @property string|null $name
     * @property string|null $icon
     * @property string|null $link
     * @property string|null $description
     * @property string|null $placeholder
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_FooterContent_QB onWriteConnection()
     * @method _IH_FooterContent_QB newQuery()
     * @method static _IH_FooterContent_QB on(null|string $connection = null)
     * @method static _IH_FooterContent_QB query()
     * @method static _IH_FooterContent_QB with(array|string $relations)
     * @method _IH_FooterContent_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_FooterContent_C|FooterContent[] all()
     * @ownLinks footer_category_id,\Modules\SystemSetting\Entities\FooterCategory,id
     * @mixin _IH_FooterContent_QB
     */
    class FooterContent extends Model {}
    
    /**
     * @property int $id
     * @property string $section
     * @property string $title
     * @property string|null $description
     * @property string|null $btn_name
     * @property string|null $btn_link
     * @property string|null $url
     * @property string|null $icon
     * @property int|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_FrontendSetting_QB onWriteConnection()
     * @method _IH_FrontendSetting_QB newQuery()
     * @method static _IH_FrontendSetting_QB on(null|string $connection = null)
     * @method static _IH_FrontendSetting_QB query()
     * @method static _IH_FrontendSetting_QB with(array|string $relations)
     * @method _IH_FrontendSetting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_FrontendSetting_C|FrontendSetting[] all()
     * @mixin _IH_FrontendSetting_QB
     */
    class FrontendSetting extends Model {}
    
    /**
     * @method static _IH_LanguagePhase_QB onWriteConnection()
     * @method _IH_LanguagePhase_QB newQuery()
     * @method static _IH_LanguagePhase_QB on(null|string $connection = null)
     * @method static _IH_LanguagePhase_QB query()
     * @method static _IH_LanguagePhase_QB with(array|string $relations)
     * @method _IH_LanguagePhase_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_LanguagePhase_C|LanguagePhase[] all()
     * @mixin _IH_LanguagePhase_QB
     */
    class LanguagePhase extends Model {}
    
    /**
     * @property int $id
     * @property int|null $sender_id
     * @property int|null $reciever_id
     * @property string $message
     * @property bool $type
     * @property bool $seen
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $message_format attribute
     * @property User|null $reciever
     * @method BelongsTo|_IH_User_QB reciever()
     * @property User|null $sender
     * @method BelongsTo|_IH_User_QB sender()
     * @method static _IH_Message_QB onWriteConnection()
     * @method _IH_Message_QB newQuery()
     * @method static _IH_Message_QB on(null|string $connection = null)
     * @method static _IH_Message_QB query()
     * @method static _IH_Message_QB with(array|string $relations)
     * @method _IH_Message_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Message_C|Message[] all()
     * @foreignLinks id,\Modules\SupportTicket\Entities\TicketMessageFile,message_id|id,\Illuminate\Notifications\DatabaseNotification,message_id
     * @mixin _IH_Message_QB
     */
    class Message extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property int $status
     * @property int $order
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $details
     * @method static _IH_Modules_QB onWriteConnection()
     * @method _IH_Modules_QB newQuery()
     * @method static _IH_Modules_QB on(null|string $connection = null)
     * @method static _IH_Modules_QB query()
     * @method static _IH_Modules_QB with(array|string $relations)
     * @method _IH_Modules_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Modules_C|Modules[] all()
     * @foreignLinks id,\Modules\RolePermission\Entities\Permission,module_id
     * @mixin _IH_Modules_QB
     */
    class Modules extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $slug
     * @property string|null $description
     * @property string|null $heading
     * @property string|null $breadcumb_image
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Page_QB onWriteConnection()
     * @method _IH_Page_QB newQuery()
     * @method static _IH_Page_QB on(null|string $connection = null)
     * @method static _IH_Page_QB query()
     * @method static _IH_Page_QB with(array|string $relations)
     * @method _IH_Page_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Page_C|Page[] all()
     * @foreignLinks id,\Modules\FooterSetting\Entities\FooterWidget,page_id
     * @mixin _IH_Page_QB
     */
    class Page extends Model {}
    
    /**
     * @property int $id
     * @property string $icon
     * @property string $name
     * @property string $link
     * @property bool $topbar
     * @property bool $footer
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_SocialLink_QB onWriteConnection()
     * @method _IH_SocialLink_QB newQuery()
     * @method static _IH_SocialLink_QB on(null|string $connection = null)
     * @method static _IH_SocialLink_QB query()
     * @method static _IH_SocialLink_QB with(array|string $relations)
     * @method _IH_SocialLink_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SocialLink_C|SocialLink[] all()
     * @mixin _IH_SocialLink_QB
     */
    class SocialLink extends Model {}
    
    /**
     * @property int $id
     * @property string|null $employee_id
     * @property int|null $user_id
     * @property int|null $department_id
     * @property int|null $showroom_id
     * @property int|null $warehouse_id
     * @property string|null $phone
     * @property string|null $bank_name
     * @property string|null $bank_branch_name
     * @property string|null $bank_account_name
     * @property string|null $bank_account_no
     * @property string|null $current_address
     * @property string|null $permanent_address
     * @property string|null $basic_salary
     * @property string|null $employment_type
     * @property float|null $opening_balance
     * @property int $provisional_months
     * @property Carbon|null $date_of_joining
     * @property Carbon|null $date_of_birth
     * @property Carbon|null $leave_applicable_date
     * @property int $carry_forward
     * @property bool $is_carry_active
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @property Department|null $department
     * @method BelongsTo|_IH_Department_QB department()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_Payroll_C|Payroll[] $payrolls
     * @property-read int $payrolls_count
     * @method HasMany|_IH_Payroll_QB payrolls()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Staff_QB onWriteConnection()
     * @method _IH_Staff_QB newQuery()
     * @method static _IH_Staff_QB on(null|string $connection = null)
     * @method static _IH_Staff_QB query()
     * @method static _IH_Staff_QB with(array|string $relations)
     * @method _IH_Staff_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Staff_C|Staff[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_Staff_QB
     */
    class Staff extends Model {}
    
    /**
     * @property int $id
     * @property int $staff_id
     * @property string|null $name
     * @property string|null $documents
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property Staff $staff
     * @method BelongsTo|_IH_Staff_QB staff()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_StaffDocument_QB onWriteConnection()
     * @method _IH_StaffDocument_QB newQuery()
     * @method static _IH_StaffDocument_QB on(null|string $connection = null)
     * @method static _IH_StaffDocument_QB query()
     * @method static _IH_StaffDocument_QB with(array|string $relations)
     * @method _IH_StaffDocument_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_StaffDocument_C|StaffDocument[] all()
     * @mixin _IH_StaffDocument_QB
     */
    class StaffDocument extends Model {}
    
    /**
     * @property int $id
     * @property string|null $body
     * @property string|null $author
     * @property string|null $profession
     * @property string|null $image
     * @property int $star
     * @property int $status
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_Testimonial_QB onWriteConnection()
     * @method _IH_Testimonial_QB newQuery()
     * @method static _IH_Testimonial_QB on(null|string $connection = null)
     * @method static _IH_Testimonial_QB query()
     * @method static _IH_Testimonial_QB with(array|string $relations)
     * @method _IH_Testimonial_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Testimonial_C|Testimonial[] all()
     * @mixin _IH_Testimonial_QB
     */
    class Testimonial extends Model {}
    
    /**
     * @property int $id
     * @property string|null $code
     * @property string|null $time_zone
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_TimeZone_QB onWriteConnection()
     * @method _IH_TimeZone_QB newQuery()
     * @method static _IH_TimeZone_QB on(null|string $connection = null)
     * @method static _IH_TimeZone_QB query()
     * @method static _IH_TimeZone_QB with(array|string $relations)
     * @method _IH_TimeZone_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TimeZone_C|TimeZone[] all()
     * @mixin _IH_TimeZone_QB
     */
    class TimeZone extends Model {}
}