<?php //96828f36df651fcde13364fc5782cba3
/** @noinspection all */

namespace Modules\Noticeboard\Entities {

    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\Noticeboard\Entities\_IH_NoticeboardAssign_C;
    use LaravelIdea\Helper\Modules\Noticeboard\Entities\_IH_NoticeboardAssign_QB;
    use LaravelIdea\Helper\Modules\Noticeboard\Entities\_IH_Noticeboard_C;
    use LaravelIdea\Helper\Modules\Noticeboard\Entities\_IH_Noticeboard_QB;
    use LaravelIdea\Helper\Modules\Noticeboard\Entities\_IH_NoticeType_C;
    use LaravelIdea\Helper\Modules\Noticeboard\Entities\_IH_NoticeType_QB;
    use LaravelIdea\Helper\Modules\RolePermission\Entities\_IH_Role_QB;
    use Modules\CourseSetting\Entities\Course;
    use Modules\RolePermission\Entities\Role;
    
    /**
     * @property int $id
     * @property string|null $title
     * @property string $color
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_NoticeType_QB onWriteConnection()
     * @method _IH_NoticeType_QB newQuery()
     * @method static _IH_NoticeType_QB on(null|string $connection = null)
     * @method static _IH_NoticeType_QB query()
     * @method static _IH_NoticeType_QB with(array|string $relations)
     * @method _IH_NoticeType_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_NoticeType_C|NoticeType[] all()
     * @mixin _IH_NoticeType_QB
     */
    class NoticeType extends Model {}
    
    /**
     * @property int $id
     * @property int|null $organization_id
     * @property int|null $user_id
     * @property int $group
     * @property int $type
     * @property string|null $title
     * @property string|null $message
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_NoticeboardAssign_C|NoticeboardAssign[] $assign
     * @property-read int $assign_count
     * @method HasMany|_IH_NoticeboardAssign_QB assign()
     * @property NoticeType $noticeType
     * @method BelongsTo|_IH_NoticeType_QB noticeType()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Noticeboard_QB onWriteConnection()
     * @method _IH_Noticeboard_QB newQuery()
     * @method static _IH_Noticeboard_QB on(null|string $connection = null)
     * @method static _IH_Noticeboard_QB query()
     * @method static _IH_Noticeboard_QB with(array|string $relations)
     * @method _IH_Noticeboard_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Noticeboard_C|Noticeboard[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @foreignLinks id,\Modules\Noticeboard\Entities\NoticeboardAssign,noticeboard_id
     * @mixin _IH_Noticeboard_QB
     */
    class Noticeboard extends Model {}
    
    /**
     * @property int $id
     * @property int $noticeboard_id
     * @property int|null $course_id
     * @property int|null $role_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property Noticeboard $notice
     * @method BelongsTo|_IH_Noticeboard_QB notice()
     * @property Role|null $role
     * @method BelongsTo|_IH_Role_QB role()
     * @method static _IH_NoticeboardAssign_QB onWriteConnection()
     * @method _IH_NoticeboardAssign_QB newQuery()
     * @method static _IH_NoticeboardAssign_QB on(null|string $connection = null)
     * @method static _IH_NoticeboardAssign_QB query()
     * @method static _IH_NoticeboardAssign_QB with(array|string $relations)
     * @method _IH_NoticeboardAssign_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_NoticeboardAssign_C|NoticeboardAssign[] all()
     * @ownLinks noticeboard_id,\Modules\Noticeboard\Entities\Noticeboard,id|course_id,\Modules\CourseSetting\Entities\Course,id|role_id,\Modules\RolePermission\Entities\Role,id
     * @mixin _IH_NoticeboardAssign_QB
     */
    class NoticeboardAssign extends Model {}
}