<?php //a3bb4fb4e7c0397dd7e738754cb97016
/** @noinspection all */

namespace Modules\Store\Entities {

    use App\City;
    use App\Country;
    use App\Models\LmsInstitute;
    use App\Models\User;
    use App\State;
    use App\User as AppUser;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\App\_IH_City_QB;
    use LaravelIdea\Helper\App\_IH_Country_QB;
    use LaravelIdea\Helper\App\_IH_State_QB;
    use LaravelIdea\Helper\App\_IH_User_QB as App_IH_User_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_Checkout_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_CancelReason_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_CancelReason_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_DeliveryProcess_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_DeliveryProcess_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_DigitalFileDownload_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_DigitalFileDownload_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ImageRefundRequest_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ImageRefundRequest_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_LabelConfig_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_LabelConfig_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_OrderDeliveryState_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_OrderDeliveryState_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_OrderPackageDetail_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_OrderPackageDetail_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_OrderProductDetail_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_OrderProductDetail_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_PickupLocation_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_PickupLocation_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductAttributeValue_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductAttributeValue_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductAttribute_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductAttribute_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductAuthor_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductAuthor_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductBrand_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductBrand_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductCarrier_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductCarrier_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductCategory_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductCategory_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductImage_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductImage_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductOrder_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductOrder_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductPublication_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductPublication_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductShipping_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductShipping_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductUnit_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductUnit_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductVariant_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ProductVariant_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_Product_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_Product_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_RefundProcess_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_RefundProcess_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_RefundProduct_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_RefundProduct_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_RefundReason_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_RefundReason_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_RefundRequestDetail_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_RefundRequestDetail_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_RefundRequest_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_RefundRequest_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_RefundState_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_RefundState_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_SellerWiseCarrierConfig_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_SellerWiseCarrierConfig_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ShippingConfiguration_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ShippingConfiguration_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ShippingMethod_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ShippingMethod_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_StoreBankPayment_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_StoreBankPayment_QB;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_EmailTemplate_C;
    use LaravelIdea\Helper\Modules\SystemSetting\Entities\_IH_EmailTemplate_QB;
    use Modules\CourseSetting\Entities\Course;
    use Modules\Payment\Entities\Checkout;
    use Modules\SystemSetting\Entities\EmailTemplate;
    
    /**
     * @property int $id
     * @property string|null $name
     * @property string|null $description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_CancelReason_QB onWriteConnection()
     * @method _IH_CancelReason_QB newQuery()
     * @method static _IH_CancelReason_QB on(null|string $connection = null)
     * @method static _IH_CancelReason_QB query()
     * @method static _IH_CancelReason_QB with(array|string $relations)
     * @method _IH_CancelReason_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CancelReason_C|CancelReason[] all()
     * @foreignLinks id,\Modules\Payment\Entities\Checkout,cancel_reason_id|id,\Modules\Store\Entities\OrderPackageDetail,cancel_reason_id
     * @mixin _IH_CancelReason_QB
     */
    class CancelReason extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property string|null $description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_EmailTemplate_C|EmailTemplate[] $email_templates
     * @property-read int $email_templates_count
     * @method MorphToMany|_IH_EmailTemplate_QB email_templates()
     * @method static _IH_DeliveryProcess_QB onWriteConnection()
     * @method _IH_DeliveryProcess_QB newQuery()
     * @method static _IH_DeliveryProcess_QB on(null|string $connection = null)
     * @method static _IH_DeliveryProcess_QB query()
     * @method static _IH_DeliveryProcess_QB with(array|string $relations)
     * @method _IH_DeliveryProcess_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DeliveryProcess_C|DeliveryProcess[] all()
     * @mixin _IH_DeliveryProcess_QB
     */
    class DeliveryProcess extends Model {}
    
    /**
     * @property int $id
     * @property int|null $customer_id
     * @property int $seller_id
     * @property int $order_id
     * @property int $package_id
     * @property int $seller_product_sku_id
     * @property int $product_sku_id
     * @property int $download_limit
     * @property int $downloaded_count
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User|null $customer
     * @method BelongsTo|_IH_User_QB customer()
     * @property ProductOrder $order
     * @method BelongsTo|_IH_ProductOrder_QB order()
     * @property OrderPackageDetail $order_package
     * @method BelongsTo|_IH_OrderPackageDetail_QB order_package()
     * @property User $seller
     * @method BelongsTo|_IH_User_QB seller()
     * @method static _IH_DigitalFileDownload_QB onWriteConnection()
     * @method _IH_DigitalFileDownload_QB newQuery()
     * @method static _IH_DigitalFileDownload_QB on(null|string $connection = null)
     * @method static _IH_DigitalFileDownload_QB query()
     * @method static _IH_DigitalFileDownload_QB with(array|string $relations)
     * @method _IH_DigitalFileDownload_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DigitalFileDownload_C|DigitalFileDownload[] all()
     * @ownLinks order_id,\App\Order,id
     * @mixin _IH_DigitalFileDownload_QB
     */
    class DigitalFileDownload extends Model {}
    
    /**
     * @property int $id
     * @property int $refund_request_id
     * @property string $image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ImageRefundRequest_QB onWriteConnection()
     * @method _IH_ImageRefundRequest_QB newQuery()
     * @method static _IH_ImageRefundRequest_QB on(null|string $connection = null)
     * @method static _IH_ImageRefundRequest_QB query()
     * @method static _IH_ImageRefundRequest_QB with(array|string $relations)
     * @method _IH_ImageRefundRequest_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ImageRefundRequest_C|ImageRefundRequest[] all()
     * @ownLinks refund_request_id,\Modules\Store\Entities\RefundRequest,id
     * @mixin _IH_ImageRefundRequest_QB
     */
    class ImageRefundRequest extends Model {}
    
    /**
     * @property int $id
     * @property string $condition
     * @property bool $status
     * @property int $created_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_LabelConfig_QB onWriteConnection()
     * @method _IH_LabelConfig_QB newQuery()
     * @method static _IH_LabelConfig_QB on(null|string $connection = null)
     * @method static _IH_LabelConfig_QB query()
     * @method static _IH_LabelConfig_QB with(array|string $relations)
     * @method _IH_LabelConfig_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_LabelConfig_C|LabelConfig[] all()
     * @mixin _IH_LabelConfig_QB
     */
    class LabelConfig extends Model {}
    
    /**
     * @property int $id
     * @property int $order_package_id
     * @property int $delivery_status
     * @property string|null $note
     * @property Carbon|null $date
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read string $delivery_state_name attribute
     * @property User|null $creator
     * @method BelongsTo|_IH_User_QB creator()
     * @property DeliveryProcess $delivery_process
     * @method BelongsTo|_IH_DeliveryProcess_QB delivery_process()
     * @method static _IH_OrderDeliveryState_QB onWriteConnection()
     * @method _IH_OrderDeliveryState_QB newQuery()
     * @method static _IH_OrderDeliveryState_QB on(null|string $connection = null)
     * @method static _IH_OrderDeliveryState_QB query()
     * @method static _IH_OrderDeliveryState_QB with(array|string $relations)
     * @method _IH_OrderDeliveryState_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrderDeliveryState_C|OrderDeliveryState[] all()
     * @ownLinks created_by,\PragmaRX\Google2FALaravel\Tests\Support\User,id|updated_by,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_OrderDeliveryState_QB
     */
    class OrderDeliveryState extends Model {}
    
    /**
     * @property int $id
     * @property int $order_id
     * @property int $seller_id
     * @property int $is_store
     * @property int $course_id
     * @property string|null $package_code
     * @property int $number_of_product
     * @property float|null $shipping_cost
     * @property string|null $shipping_date
     * @property int|null $shipping_method
     * @property int $is_cancelled
     * @property int|null $cancel_reason_id
     * @property int $is_reviewed
     * @property int $delivery_status
     * @property int|null $last_updated_by
     * @property bool $gst_claimed
     * @property float|null $tax_amount
     * @property string|null $carrier_order_id
     * @property string|null $carrier_id
     * @property string|null $shipped_by
     * @property string|null $carrier_response
     * @property int|null $pickup_point_id
     * @property bool $is_paid
     * @property float|null $weight
     * @property float|null $length
     * @property float|null $breadth
     * @property float|null $height
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read string|void $delivery_state_name attribute
     * @property-read $processes attribute
     * @property-read int $total_g_s_t attribute
     * @property CancelReason|null $cancel_reason
     * @method BelongsTo|_IH_CancelReason_QB cancel_reason()
     * @property ProductCarrier|null $carrier
     * @method BelongsTo|_IH_ProductCarrier_QB carrier()
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property DeliveryProcess $delivery_process
     * @method BelongsTo|_IH_DeliveryProcess_QB delivery_process()
     * @property Checkout $order
     * @method BelongsTo|_IH_Checkout_QB order()
     * @property PickupLocation|null $pickupPoint
     * @method BelongsTo|_IH_PickupLocation_QB pickupPoint()
     * @property _IH_OrderProductDetail_C|OrderProductDetail[] $product_details
     * @property-read int $product_details_count
     * @method HasMany|_IH_OrderProductDetail_QB product_details()
     * @property _IH_OrderProductDetail_C|OrderProductDetail[] $products
     * @property-read int $products_count
     * @method HasMany|_IH_OrderProductDetail_QB products()
     * @property RefundRequestDetail $refundPackage
     * @method HasOne|_IH_RefundRequestDetail_QB refundPackage()
     * @property User $seller
     * @method BelongsTo|_IH_User_QB seller()
     * @property ShippingMethod|null $shipping
     * @method BelongsTo|_IH_ShippingMethod_QB shipping()
     * @method static _IH_OrderPackageDetail_QB onWriteConnection()
     * @method _IH_OrderPackageDetail_QB newQuery()
     * @method static _IH_OrderPackageDetail_QB on(null|string $connection = null)
     * @method static _IH_OrderPackageDetail_QB query()
     * @method static _IH_OrderPackageDetail_QB with(array|string $relations)
     * @method _IH_OrderPackageDetail_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrderPackageDetail_C|OrderPackageDetail[] all()
     * @ownLinks order_id,\App\Order,id|course_id,\Modules\CourseSetting\Entities\Course,id|cancel_reason_id,\Modules\Store\Entities\CancelReason,id
     * @mixin _IH_OrderPackageDetail_QB
     */
    class OrderPackageDetail extends Model {}
    
    /**
     * @property int $id
     * @property int $package_id
     * @property int $is_store
     * @property int $seller_id
     * @property int $course_id
     * @property string|null $type
     * @property int $qty
     * @property float $price
     * @property float $total_price
     * @property float $tax_amount
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property Course $getCourse
     * @method BelongsTo|_IH_Course_QB getCourse()
     * @property OrderPackageDetail $package
     * @method BelongsTo|_IH_OrderPackageDetail_QB package()
     * @method static _IH_OrderProductDetail_QB onWriteConnection()
     * @method _IH_OrderProductDetail_QB newQuery()
     * @method static _IH_OrderProductDetail_QB on(null|string $connection = null)
     * @method static _IH_OrderProductDetail_QB query()
     * @method static _IH_OrderProductDetail_QB with(array|string $relations)
     * @method _IH_OrderProductDetail_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrderProductDetail_C|OrderProductDetail[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id
     * @mixin _IH_OrderProductDetail_QB
     */
    class OrderProductDetail extends Model {}
    
    /**
     * @property int $id
     * @property string|null $pickup_location
     * @property string|null $name
     * @property string|null $email
     * @property string|null $phone
     * @property string|null $address
     * @property string|null $address_2
     * @property int|null $city_id
     * @property int|null $state_id
     * @property int|null $country_id
     * @property int|null $pin_code
     * @property float|null $lat
     * @property float|null $long
     * @property bool $status
     * @property bool $is_set
     * @property bool $is_default
     * @property int|null $created_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property City|null $city
     * @method BelongsTo|_IH_City_QB city()
     * @property Country|null $country
     * @method BelongsTo|_IH_Country_QB country()
     * @property State|null $state
     * @method BelongsTo|_IH_State_QB state()
     * @method static _IH_PickupLocation_QB onWriteConnection()
     * @method _IH_PickupLocation_QB newQuery()
     * @method static _IH_PickupLocation_QB on(null|string $connection = null)
     * @method static _IH_PickupLocation_QB query()
     * @method static _IH_PickupLocation_QB with(array|string $relations)
     * @method _IH_PickupLocation_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PickupLocation_C|PickupLocation[] all()
     * @ownLinks state_id,\App\State,id|country_id,\App\Country,id
     * @foreignLinks id,\Modules\Store\Entities\ProductOrder,pickup_location_id
     * @mixin _IH_PickupLocation_QB
     */
    class PickupLocation extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $title
     * @property string|null $description
     * @property int $status
     * @property int $category_id
     * @property int|null $sub_category_id
     * @property int|null $author_id
     * @property int|null $brand_id
     * @property float $price
     * @property string|null $discount_type
     * @property float $discount
     * @property string|null $image
     * @property string|null $thumbnail
     * @property int $is_readable
     * @property string|null $link
     * @property int|null $inventory
     * @property int|null $inventory_warning
     * @property float|null $delivery_fee
     * @property int|null $delivery_estimated_time
     * @property int $type
     * @property int|null $commission
     * @property string|null $pdf
     * @property string|null $soft_file
     * @property string|null $specification
     * @property string|null $faq
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property ProductBrand|null $brand
     * @method BelongsTo|_IH_ProductBrand_QB brand()
     * @property ProductCategory $category
     * @method BelongsTo|_IH_ProductCategory_QB category()
     * @property Course $course
     * @method HasOne|_IH_Course_QB course()
     * @property _IH_ProductImage_C|ProductImage[] $product_image
     * @property-read int $product_image_count
     * @method HasMany|_IH_ProductImage_QB product_image()
     * @property ProductCategory|null $subCategory
     * @method BelongsTo|_IH_ProductCategory_QB subCategory()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @property _IH_ProductVariant_C|ProductVariant[] $variations
     * @property-read int $variations_count
     * @method HasMany|_IH_ProductVariant_QB variations()
     * @method static _IH_Product_QB onWriteConnection()
     * @method _IH_Product_QB newQuery()
     * @method static _IH_Product_QB on(null|string $connection = null)
     * @method static _IH_Product_QB query()
     * @method static _IH_Product_QB with(array|string $relations)
     * @method _IH_Product_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Product_C|Product[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|category_id,\Modules\CourseSetting\Entities\Category,id|sub_category_id,\Modules\CourseSetting\Entities\SubCategory,id
     * @foreignLinks id,\Modules\CourseSetting\Entities\Course,product_id|id,\Modules\Store\Entities\ProductVariant,product_id|id,\Modules\Store\Entities\ProductOrder,product_id|id,\Modules\Store\Entities\ProductShipping,product_id|id,\Modules\Cashback\Entities\UserCashbackDetail,product_id|id,\Modules\Store\Entities\ProductImage,product_id
     * @mixin _IH_Product_QB
     */
    class Product extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $title
     * @property string|null $display_type
     * @property bool $status
     * @property int $lms_id
     * @property string|null $description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property AppUser $user
     * @method BelongsTo|App_IH_User_QB user()
     * @property _IH_ProductAttributeValue_C|ProductAttributeValue[] $values
     * @property-read int $values_count
     * @method HasMany|_IH_ProductAttributeValue_QB values()
     * @method static _IH_ProductAttribute_QB onWriteConnection()
     * @method _IH_ProductAttribute_QB newQuery()
     * @method static _IH_ProductAttribute_QB on(null|string $connection = null)
     * @method static _IH_ProductAttribute_QB query()
     * @method static _IH_ProductAttribute_QB with(array|string $relations)
     * @method _IH_ProductAttribute_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductAttribute_C|ProductAttribute[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @foreignLinks id,\Modules\Store\Entities\ProductAttributeValue,product_attribute_id
     * @mixin _IH_ProductAttribute_QB
     */
    class ProductAttribute extends Model {}
    
    /**
     * @property int $id
     * @property string $value
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $product_attribute_id
     * @property ProductAttribute $attribute
     * @method BelongsTo|_IH_ProductAttribute_QB attribute()
     * @property ProductVariant $productVariation
     * @method HasOne|_IH_ProductVariant_QB productVariation()
     * @method static _IH_ProductAttributeValue_QB onWriteConnection()
     * @method _IH_ProductAttributeValue_QB newQuery()
     * @method static _IH_ProductAttributeValue_QB on(null|string $connection = null)
     * @method static _IH_ProductAttributeValue_QB query()
     * @method static _IH_ProductAttributeValue_QB with(array|string $relations)
     * @method _IH_ProductAttributeValue_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductAttributeValue_C|ProductAttributeValue[] all()
     * @ownLinks product_attribute_id,\Modules\Store\Entities\ProductAttribute,id
     * @mixin _IH_ProductAttributeValue_QB
     */
    class ProductAttributeValue extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $title
     * @property bool $status
     * @property int $lms_id
     * @property string|null $image
     * @property string|null $description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property AppUser $user
     * @method BelongsTo|App_IH_User_QB user()
     * @method static _IH_ProductAuthor_QB onWriteConnection()
     * @method _IH_ProductAuthor_QB newQuery()
     * @method static _IH_ProductAuthor_QB on(null|string $connection = null)
     * @method static _IH_ProductAuthor_QB query()
     * @method static _IH_ProductAuthor_QB with(array|string $relations)
     * @method _IH_ProductAuthor_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductAuthor_C|ProductAuthor[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_ProductAuthor_QB
     */
    class ProductAuthor extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $logo
     * @property string|null $description
     * @property string|null $link
     * @property bool $status
     * @property bool $featured
     * @property string|null $meta_title
     * @property string|null $meta_description
     * @property int|null $sort_id
     * @property int $total_sale
     * @property float $avg_rating
     * @property string|null $slug
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property _IH_Product_C|Product[] $products
     * @property-read int $products_count
     * @method HasMany|_IH_Product_QB products()
     * @method static _IH_ProductBrand_QB onWriteConnection()
     * @method _IH_ProductBrand_QB newQuery()
     * @method static _IH_ProductBrand_QB on(null|string $connection = null)
     * @method static _IH_ProductBrand_QB query()
     * @method static _IH_ProductBrand_QB with(array|string $relations)
     * @method _IH_ProductBrand_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductBrand_C|ProductBrand[] all()
     * @ownLinks created_by,\PragmaRX\Google2FALaravel\Tests\Support\User,id|updated_by,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_ProductBrand_QB
     */
    class ProductBrand extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $logo
     * @property string $type
     * @property string|null $slug
     * @property string|null $tracking_url
     * @property bool $status
     * @property int $created_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property SellerWiseCarrierConfig $carrierConfig
     * @method HasOne|_IH_SellerWiseCarrierConfig_QB carrierConfig()
     * @property SellerWiseCarrierConfig $carrierConfigFrontend
     * @method HasOne|_IH_SellerWiseCarrierConfig_QB carrierConfigFrontend()
     * @property _IH_ShippingMethod_C|ShippingMethod[] $shippingMethods
     * @property-read int $shipping_methods_count
     * @method HasMany|_IH_ShippingMethod_QB shippingMethods()
     * @method static _IH_ProductCarrier_QB onWriteConnection()
     * @method _IH_ProductCarrier_QB newQuery()
     * @method static _IH_ProductCarrier_QB on(null|string $connection = null)
     * @method static _IH_ProductCarrier_QB query()
     * @method static _IH_ProductCarrier_QB with(array|string $relations)
     * @method _IH_ProductCarrier_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductCarrier_C|ProductCarrier[] all()
     * @foreignLinks id,\Modules\Store\Entities\ShippingMethod,carrier_id
     * @mixin _IH_ProductCarrier_QB
     */
    class ProductCarrier extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string $title
     * @property int $position_order
     * @property bool $status
     * @property int|null $parent_id
     * @property int $lms_id
     * @property string|null $tags
     * @property string|null $image
     * @property string|null $thumbnail
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property _IH_ProductCategory_C|ProductCategory[] $childs
     * @property-read int $childs_count
     * @method HasMany|_IH_ProductCategory_QB childs()
     * @property ProductCategory|null $parent
     * @method BelongsTo|_IH_ProductCategory_QB parent()
     * @property _IH_Product_C|Product[] $products
     * @property-read int $products_count
     * @method HasMany|_IH_Product_QB products()
     * @property _IH_ProductCategory_C|ProductCategory[] $subcategories
     * @property-read int $subcategories_count
     * @method HasMany|_IH_ProductCategory_QB subcategories()
     * @property AppUser $user
     * @method BelongsTo|App_IH_User_QB user()
     * @method static _IH_ProductCategory_QB onWriteConnection()
     * @method _IH_ProductCategory_QB newQuery()
     * @method static _IH_ProductCategory_QB on(null|string $connection = null)
     * @method static _IH_ProductCategory_QB query()
     * @method static _IH_ProductCategory_QB with(array|string $relations)
     * @method _IH_ProductCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductCategory_C|ProductCategory[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_ProductCategory_QB
     */
    class ProductCategory extends Model {}
    
    /**
     * @property int $id
     * @property int|null $product_id
     * @property string|null $thumbnail
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ProductImage_QB onWriteConnection()
     * @method _IH_ProductImage_QB newQuery()
     * @method static _IH_ProductImage_QB on(null|string $connection = null)
     * @method static _IH_ProductImage_QB query()
     * @method static _IH_ProductImage_QB with(array|string $relations)
     * @method _IH_ProductImage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductImage_C|ProductImage[] all()
     * @ownLinks product_id,\Modules\Store\Entities\Product,id
     * @mixin _IH_ProductImage_QB
     */
    class ProductImage extends Model {}
    
    /**
     * @property int $id
     * @property string|null $order_id
     * @property int|null $product_id
     * @property int|null $customer_id
     * @property int|null $quantity
     * @property float|null $unit_price
     * @property float|null $total_price
     * @property float|null $discount_amount
     * @property float|null $net_price
     * @property int|null $payment_method
     * @property int|null $payment_status
     * @property int|null $order_status
     * @property Carbon|null $order_date
     * @property Carbon|null $delivery_date
     * @property int|null $discount_assigned_by
     * @property string|null $discount_code
     * @property string|null $delivery_type
     * @property int|null $pickup_location_id
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User|null $customer
     * @method BelongsTo|_IH_User_QB customer()
     * @property User|null $discountAssignedBy
     * @method BelongsTo|_IH_User_QB discountAssignedBy()
     * @property Product|null $product
     * @method BelongsTo|_IH_Product_QB product()
     * @method static _IH_ProductOrder_QB onWriteConnection()
     * @method _IH_ProductOrder_QB newQuery()
     * @method static _IH_ProductOrder_QB on(null|string $connection = null)
     * @method static _IH_ProductOrder_QB query()
     * @method static _IH_ProductOrder_QB with(array|string $relations)
     * @method _IH_ProductOrder_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductOrder_C|ProductOrder[] all()
     * @ownLinks order_id,\App\Order,id|product_id,\Modules\Store\Entities\Product,id|pickup_location_id,\Modules\Store\Entities\PickupLocation,id
     * @mixin _IH_ProductOrder_QB
     */
    class ProductOrder extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $description
     * @property string|null $logo
     * @property bool $status
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_ProductPublication_QB onWriteConnection()
     * @method _IH_ProductPublication_QB newQuery()
     * @method static _IH_ProductPublication_QB on(null|string $connection = null)
     * @method static _IH_ProductPublication_QB query()
     * @method static _IH_ProductPublication_QB with(array|string $relations)
     * @method _IH_ProductPublication_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductPublication_C|ProductPublication[] all()
     * @ownLinks created_by,\PragmaRX\Google2FALaravel\Tests\Support\User,id|updated_by,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_ProductPublication_QB
     */
    class ProductPublication extends Model {}
    
    /**
     * @property int $id
     * @property int $product_id
     * @property int $shipping_method_id
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Product $product
     * @method BelongsTo|_IH_Product_QB product()
     * @property ShippingMethod $shippingMethod
     * @method BelongsTo|_IH_ShippingMethod_QB shippingMethod()
     * @method static _IH_ProductShipping_QB onWriteConnection()
     * @method _IH_ProductShipping_QB newQuery()
     * @method static _IH_ProductShipping_QB on(null|string $connection = null)
     * @method static _IH_ProductShipping_QB query()
     * @method static _IH_ProductShipping_QB with(array|string $relations)
     * @method _IH_ProductShipping_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductShipping_C|ProductShipping[] all()
     * @ownLinks product_id,\Modules\Store\Entities\Product,id|shipping_method_id,\Modules\Store\Entities\ShippingMethod,id
     * @mixin _IH_ProductShipping_QB
     */
    class ProductShipping extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $description
     * @property bool $status
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_ProductUnit_QB onWriteConnection()
     * @method _IH_ProductUnit_QB newQuery()
     * @method static _IH_ProductUnit_QB on(null|string $connection = null)
     * @method static _IH_ProductUnit_QB query()
     * @method static _IH_ProductUnit_QB with(array|string $relations)
     * @method _IH_ProductUnit_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductUnit_C|ProductUnit[] all()
     * @ownLinks created_by,\PragmaRX\Google2FALaravel\Tests\Support\User,id|updated_by,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_ProductUnit_QB
     */
    class ProductUnit extends Model {}
    
    /**
     * @property int $id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $attribute_id
     * @property int|null $attribute_value_id
     * @property int|null $product_id
     * @property float|null $product_price
     * @property string|null $variant_image
     * @property bool $status
     * @property int $product_stock
     * @property ProductAttribute|null $attribute
     * @method BelongsTo|_IH_ProductAttribute_QB attribute()
     * @property ProductAttributeValue|null $attributevalue
     * @method BelongsTo|_IH_ProductAttributeValue_QB attributevalue()
     * @method static _IH_ProductVariant_QB onWriteConnection()
     * @method _IH_ProductVariant_QB newQuery()
     * @method static _IH_ProductVariant_QB on(null|string $connection = null)
     * @method static _IH_ProductVariant_QB query()
     * @method static _IH_ProductVariant_QB with(array|string $relations)
     * @method _IH_ProductVariant_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductVariant_C|ProductVariant[] all()
     * @ownLinks product_id,\Modules\Store\Entities\Product,id
     * @mixin _IH_ProductVariant_QB
     */
    class ProductVariant extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property string|null $description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_RefundProcess_QB onWriteConnection()
     * @method _IH_RefundProcess_QB newQuery()
     * @method static _IH_RefundProcess_QB on(null|string $connection = null)
     * @method static _IH_RefundProcess_QB query()
     * @method static _IH_RefundProcess_QB with(array|string $relations)
     * @method _IH_RefundProcess_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RefundProcess_C|RefundProcess[] all()
     * @mixin _IH_RefundProcess_QB
     */
    class RefundProcess extends Model {}
    
    /**
     * @property int $id
     * @property int $refund_request_detail_id
     * @property int $seller_product_sku_id
     * @property int $refund_reason_id
     * @property int|null $return_qty
     * @property float $return_amount
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property RefundReason $refund_reason
     * @method BelongsTo|_IH_RefundReason_QB refund_reason()
     * @method static _IH_RefundProduct_QB onWriteConnection()
     * @method _IH_RefundProduct_QB newQuery()
     * @method static _IH_RefundProduct_QB on(null|string $connection = null)
     * @method static _IH_RefundProduct_QB query()
     * @method static _IH_RefundProduct_QB with(array|string $relations)
     * @method _IH_RefundProduct_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RefundProduct_C|RefundProduct[] all()
     * @ownLinks refund_request_detail_id,\Modules\Store\Entities\RefundRequestDetail,id|refund_reason_id,\Modules\Store\Entities\RefundReason,id
     * @mixin _IH_RefundProduct_QB
     */
    class RefundProduct extends Model {}
    
    /**
     * @property int $id
     * @property string|null $reason
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_RefundReason_QB onWriteConnection()
     * @method _IH_RefundReason_QB newQuery()
     * @method static _IH_RefundReason_QB on(null|string $connection = null)
     * @method static _IH_RefundReason_QB query()
     * @method static _IH_RefundReason_QB with(array|string $relations)
     * @method _IH_RefundReason_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RefundReason_C|RefundReason[] all()
     * @foreignLinks id,\Modules\Store\Entities\RefundProduct,refund_reason_id
     * @mixin _IH_RefundReason_QB
     */
    class RefundReason extends Model {}
    
    /**
     * @property int $id
     * @property int $customer_id
     * @property int $order_id
     * @property string|null $refund_method
     * @property string|null $shipping_method
     * @property int|null $shipping_method_id
     * @property int|null $pick_up_address_id
     * @property string|null $drop_off_address
     * @property string|null $additional_info
     * @property float $total_return_amount
     * @property int $refund_state
     * @property bool $is_confirmed
     * @property bool $is_refunded
     * @property bool $is_completed
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read string $check_confirmed attribute
     * @property StoreBankPayment $bank_payments
     * @method MorphToMany|_IH_StoreBankPayment_QB bank_payments()
     * @property AppUser $customer
     * @method BelongsTo|App_IH_User_QB customer()
     * @property Checkout $order
     * @method BelongsTo|_IH_Checkout_QB order()
     * @property _IH_RefundRequestDetail_C|RefundRequestDetail[] $refund_details
     * @property-read int $refund_details_count
     * @method HasMany|_IH_RefundRequestDetail_QB refund_details()
     * @property _IH_ImageRefundRequest_C|ImageRefundRequest[] $refund_images
     * @property-read int $refund_images_count
     * @method HasMany|_IH_ImageRefundRequest_QB refund_images()
     * @property ShippingMethod|null $shipping_gateway
     * @method BelongsTo|_IH_ShippingMethod_QB shipping_gateway()
     * @method static _IH_RefundRequest_QB onWriteConnection()
     * @method _IH_RefundRequest_QB newQuery()
     * @method static _IH_RefundRequest_QB on(null|string $connection = null)
     * @method static _IH_RefundRequest_QB query()
     * @method static _IH_RefundRequest_QB with(array|string $relations)
     * @method _IH_RefundRequest_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RefundRequest_C|RefundRequest[] all()
     * @ownLinks order_id,\App\Order,id|shipping_method_id,\Modules\Store\Entities\ShippingMethod,id
     * @foreignLinks id,\Modules\Store\Entities\ImageRefundRequest,refund_request_id|id,\Modules\Store\Entities\RefundRequestDetail,refund_request_id
     * @mixin _IH_RefundRequest_QB
     */
    class RefundRequest extends Model {}
    
    /**
     * @property int $id
     * @property int $refund_request_id
     * @property int $order_package_id
     * @property int $seller_id
     * @property int $processing_state
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property OrderPackageDetail $order_package
     * @method BelongsTo|_IH_OrderPackageDetail_QB order_package()
     * @property RefundProcess $process_refund
     * @method BelongsTo|_IH_RefundProcess_QB process_refund()
     * @property _IH_OrderPackageDetail_C|OrderPackageDetail[] $refund_product_details
     * @property-read int $refund_product_details_count
     * @method HasMany|_IH_OrderPackageDetail_QB refund_product_details()
     * @property _IH_RefundProduct_C|RefundProduct[] $refund_products
     * @property-read int $refund_products_count
     * @method HasMany|_IH_RefundProduct_QB refund_products()
     * @property RefundRequest $refund_request
     * @method BelongsTo|_IH_RefundRequest_QB refund_request()
     * @property RefundProduct $refund_single
     * @method HasOne|_IH_RefundProduct_QB refund_single()
     * @property AppUser $seller
     * @method BelongsTo|App_IH_User_QB seller()
     * @method static _IH_RefundRequestDetail_QB onWriteConnection()
     * @method _IH_RefundRequestDetail_QB newQuery()
     * @method static _IH_RefundRequestDetail_QB on(null|string $connection = null)
     * @method static _IH_RefundRequestDetail_QB query()
     * @method static _IH_RefundRequestDetail_QB with(array|string $relations)
     * @method _IH_RefundRequestDetail_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RefundRequestDetail_C|RefundRequestDetail[] all()
     * @ownLinks refund_request_id,\Modules\Store\Entities\RefundRequest,id
     * @foreignLinks id,\Modules\Store\Entities\RefundProduct,refund_request_detail_id|id,\Modules\Store\Entities\RefundState,refund_request_detail_id
     * @mixin _IH_RefundRequestDetail_QB
     */
    class RefundRequestDetail extends Model {}
    
    /**
     * @property int $id
     * @property int $refund_request_detail_id
     * @property int $state
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_RefundState_QB onWriteConnection()
     * @method _IH_RefundState_QB newQuery()
     * @method static _IH_RefundState_QB on(null|string $connection = null)
     * @method static _IH_RefundState_QB query()
     * @method static _IH_RefundState_QB with(array|string $relations)
     * @method _IH_RefundState_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RefundState_C|RefundState[] all()
     * @ownLinks refund_request_detail_id,\Modules\Store\Entities\RefundRequestDetail,id
     * @mixin _IH_RefundState_QB
     */
    class RefundState extends Model {}
    
    /**
     * @property int $id
     * @property int $carrier_id
     * @property int $seller_id
     * @property bool $carrier_status
     * @property string|null $email
     * @property string|null $password
     * @property string|null $channel_id
     * @property string|null $logo
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_SellerWiseCarrierConfig_QB onWriteConnection()
     * @method _IH_SellerWiseCarrierConfig_QB newQuery()
     * @method static _IH_SellerWiseCarrierConfig_QB on(null|string $connection = null)
     * @method static _IH_SellerWiseCarrierConfig_QB query()
     * @method static _IH_SellerWiseCarrierConfig_QB with(array|string $relations)
     * @method _IH_SellerWiseCarrierConfig_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SellerWiseCarrierConfig_C|SellerWiseCarrierConfig[] all()
     * @mixin _IH_SellerWiseCarrierConfig_QB
     */
    class SellerWiseCarrierConfig extends Model {}
    
    /**
     * @property int $id
     * @property int|null $seller_id
     * @property string|null $order_confirm_and_sync
     * @property bool|null $carrier_show_for_customer
     * @property int|null $default_carrier
     * @property bool|null $order_auto_confirm
     * @property int|null $pickup_location
     * @property bool|null $refund_order_sync_carrier
     * @property bool|null $seller_use_shiproket
     * @property string|null $carrier_order_type
     * @property string|null $label_code
     * @property bool $amount_multiply_with_qty
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ShippingConfiguration_QB onWriteConnection()
     * @method _IH_ShippingConfiguration_QB newQuery()
     * @method static _IH_ShippingConfiguration_QB on(null|string $connection = null)
     * @method static _IH_ShippingConfiguration_QB query()
     * @method static _IH_ShippingConfiguration_QB with(array|string $relations)
     * @method _IH_ShippingConfiguration_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ShippingConfiguration_C|ShippingConfiguration[] all()
     * @mixin _IH_ShippingConfiguration_QB
     */
    class ShippingConfiguration extends Model {}
    
    /**
     * @property int $id
     * @property string|null $method_name
     * @property string|null $logo
     * @property string|null $phone
     * @property string|null $shipment_time
     * @property float $cost
     * @property float $minimum_shopping
     * @property bool $is_active
     * @property int|null $request_by_user
     * @property bool $is_approved
     * @property int $carrier_id
     * @property string $cost_based_on
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property ProductCarrier $carrier
     * @method BelongsTo|_IH_ProductCarrier_QB carrier()
     * @property _IH_ProductShipping_C|ProductShipping[] $methodUse
     * @property-read int $method_use_count
     * @method HasMany|_IH_ProductShipping_QB methodUse()
     * @property User|null $request_user
     * @method BelongsTo|_IH_User_QB request_user()
     * @method static _IH_ShippingMethod_QB onWriteConnection()
     * @method _IH_ShippingMethod_QB newQuery()
     * @method static _IH_ShippingMethod_QB on(null|string $connection = null)
     * @method static _IH_ShippingMethod_QB query()
     * @method static _IH_ShippingMethod_QB with(array|string $relations)
     * @method _IH_ShippingMethod_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ShippingMethod_C|ShippingMethod[] all()
     * @ownLinks carrier_id,\Modules\Store\Entities\ProductCarrier,id
     * @foreignLinks id,\Modules\Store\Entities\ProductShipping,shipping_method_id|id,\Modules\Store\Entities\RefundRequest,shipping_method_id
     * @mixin _IH_ShippingMethod_QB
     */
    class ShippingMethod extends Model {}
    
    /**
     * @property int $id
     * @property int|null $itemable_id
     * @property string|null $itemable_type
     * @property string|null $bank_name
     * @property string|null $branch_name
     * @property string|null $account_number
     * @property string|null $account_holder
     * @property string|null $image_src
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_StoreBankPayment_QB onWriteConnection()
     * @method _IH_StoreBankPayment_QB newQuery()
     * @method static _IH_StoreBankPayment_QB on(null|string $connection = null)
     * @method static _IH_StoreBankPayment_QB query()
     * @method static _IH_StoreBankPayment_QB with(array|string $relations)
     * @method _IH_StoreBankPayment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_StoreBankPayment_C|StoreBankPayment[] all()
     * @mixin _IH_StoreBankPayment_QB
     */
    class StoreBankPayment extends Model {}
}