<?php //82695a9a6206004cf5eced1ce6d4d2ce
/** @noinspection all */

namespace Modules\Payment\Entities {

    use App\BillingDetails;
    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_BillingDetails_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Appointment\Entities\_IH_Schedule_QB;
    use LaravelIdea\Helper\Modules\BundleSubscription\Entities\_IH_BundleCoursePlan_QB;
    use LaravelIdea\Helper\Modules\Coupons\Entities\_IH_Coupon_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseEnrolled_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseEnrolled_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Package_QB;
    use LaravelIdea\Helper\Modules\Gift\Entities\_IH_GiftCart_C;
    use LaravelIdea\Helper\Modules\Gift\Entities\_IH_GiftCart_QB;
    use LaravelIdea\Helper\Modules\Gift\Entities\_IH_GiftRecord_QB;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_InstallmentPurchaseRequest_QB;
    use LaravelIdea\Helper\Modules\Invoice\Entities\_IH_Invoice_QB;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_Cart_C;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_Cart_QB;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_Checkout_C;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_Checkout_QB;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_GateWay_C;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_GateWay_QB;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_InstructorPayout_C;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_InstructorPayout_QB;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_InstructorTotalPayout_C;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_InstructorTotalPayout_QB;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_Subscriber_C;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_Subscriber_QB;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_Withdraw_C;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_Withdraw_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_CancelReason_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_OrderPackageDetail_C;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_OrderPackageDetail_QB;
    use LaravelIdea\Helper\Modules\Store\Entities\_IH_ShippingMethod_QB;
    use Modules\Appointment\Entities\Schedule;
    use Modules\BundleSubscription\Entities\BundleCoursePlan;
    use Modules\Coupons\Entities\Coupon;
    use Modules\CourseSetting\Entities\Course;
    use Modules\CourseSetting\Entities\CourseEnrolled;
    use Modules\CourseSetting\Entities\Package;
    use Modules\Gift\Entities\GiftCart;
    use Modules\Gift\Entities\GiftRecord;
    use Modules\Installment\Entities\InstallmentPurchaseRequest;
    use Modules\Invoice\Entities\Invoice;
    use Modules\Store\Entities\CancelReason;
    use Modules\Store\Entities\OrderPackageDetail;
    use Modules\Store\Entities\ShippingMethod;
    
    /**
     * @property int $id
     * @property int|null $course_id
     * @property int $user_id
     * @property int $instructor_id
     * @property string $tracking
     * @property float|null $price
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $bundle_course_id
     * @property Carbon|null $bundle_course_validity
     * @property bool $renew
     * @property string|null $type
     * @property int|null $schedule_id
     * @property int|null $timezone
     * @property bool $is_gift
     * @property int|null $gift_id
     * @property float $pre_booking_amount
     * @property bool $is_installment
     * @property int|null $plan_id
     * @property string|null $installment_type
     * @property int|null $purchase_id
     * @property bool|null $is_earlybird_offer
     * @property int|null $price_plan_id
     * @property int $qty
     * @property bool $is_store
     * @property float $group_discount
     * @property BundleCoursePlan $bundle
     * @method BelongsTo|_IH_BundleCoursePlan_QB bundle()
     * @property GiftRecord|null $cart_gift
     * @method BelongsTo|_IH_GiftRecord_QB cart_gift()
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property InstallmentPurchaseRequest|null $installmentPurchase
     * @method BelongsTo|_IH_InstallmentPurchaseRequest_QB installmentPurchase()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User $instructor
     * @method BelongsTo|_IH_User_QB instructor()
     * @property Schedule|null $schedule
     * @method BelongsTo|_IH_Schedule_QB schedule()
     * @property User $student
     * @method BelongsTo|_IH_User_QB student()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Cart_QB onWriteConnection()
     * @method _IH_Cart_QB newQuery()
     * @method static _IH_Cart_QB on(null|string $connection = null)
     * @method static _IH_Cart_QB query()
     * @method static _IH_Cart_QB with(array|string $relations)
     * @method _IH_Cart_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Cart_C|Cart[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|bundle_course_id,\Modules\BundleSubscription\Entities\BundleCourse,id|schedule_id,\Modules\Appointment\Entities\Schedule,id|price_plan_id,\Modules\EarlyBird\Entities\PricePlan,id
     * @foreignLinks id,\Modules\Gift\Entities\GiftRecord,cart_id
     * @mixin _IH_Cart_QB
     */
    class Cart extends Model {}
    
    /**
     * @property int $id
     * @property string $tracking
     * @property int $user_id
     * @property int|null $billing_detail_id
     * @property int|null $package_id
     * @property int|null $coupon_id
     * @property float|null $discount
     * @property float|null $purchase_price
     * @property float|null $price
     * @property bool $status
     * @property string|null $payment_method
     * @property string|null $response
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $tax
     * @property int|null $payment_type
     * @property string|null $course_type
     * @property string|null $bundle_reveune
     * @property bool $renew
     * @property int|null $bundle_id
     * @property string|null $type
     * @property string|null $invoice_id
     * @property string|null $order_certificate_id
     * @property float $pre_booking_amount
     * @property int|null $cart_count
     * @property int|null $has_gift
     * @property float $group_discount
     * @property string|null $order_number
     * @property int $is_paid
     * @property int $is_confirmed
     * @property int $is_completed
     * @property int $is_cancelled
     * @property int|null $cancel_reason_id
     * @property int|null $shipping_id
     * @property bool $is_store
     * @property int $order_status
     * @property string|null $shipping_cost
     * @property int $is_received
     * @property-read $date_format attribute
     * @property BillingDetails $bill
     * @method BelongsTo|_IH_BillingDetails_QB bill()
     * @property BillingDetails|null $billing
     * @method BelongsTo|_IH_BillingDetails_QB billing()
     * @property BundleCoursePlan|null $bundle
     * @method BelongsTo|_IH_BundleCoursePlan_QB bundle()
     * @property CancelReason|null $cancel_reason
     * @method BelongsTo|_IH_CancelReason_QB cancel_reason()
     * @property _IH_Cart_C|Cart[] $carts
     * @property-read int $carts_count
     * @method HasMany|_IH_Cart_QB carts()
     * @property Coupon|null $coupon
     * @method BelongsTo|_IH_Coupon_QB coupon()
     * @property _IH_CourseEnrolled_C|CourseEnrolled[] $courses
     * @property-read int $courses_count
     * @method HasMany|_IH_CourseEnrolled_QB courses()
     * @property _IH_GiftCart_C|GiftCart[] $gifts
     * @property-read int $gifts_count
     * @method HasMany|_IH_GiftCart_QB gifts()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property Invoice|null $invoice
     * @method BelongsTo|_IH_Invoice_QB invoice()
     * @property _IH_OrderPackageDetail_C|OrderPackageDetail[] $packages
     * @property-read int $packages_count
     * @method HasMany|_IH_OrderPackageDetail_QB packages()
     * @property ShippingMethod|null $shipping
     * @method BelongsTo|_IH_ShippingMethod_QB shipping()
     * @property OrderPackageDetail $singlePackage
     * @method HasOne|_IH_OrderPackageDetail_QB singlePackage()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Checkout_QB onWriteConnection()
     * @method _IH_Checkout_QB newQuery()
     * @method static _IH_Checkout_QB on(null|string $connection = null)
     * @method static _IH_Checkout_QB query()
     * @method static _IH_Checkout_QB with(array|string $relations)
     * @method _IH_Checkout_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Checkout_C|Checkout[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|billing_detail_id,\App\BillingDetails,id|coupon_id,\Modules\Coupons\Entities\Coupon,id|invoice_id,\Modules\Invoice\Entities\Invoice,id|order_certificate_id,\Modules\Invoice\Entities\OrderCertificate,id|cancel_reason_id,\Modules\Store\Entities\CancelReason,id
     * @foreignLinks id,\Modules\Subscription\Entities\SubscriptionCourse,checkout_id|id,\Modules\Mobilpay\Entities\MobilPayOrder,checkout_id|id,\Modules\Invoice\Entities\Invoice,checkout_id|id,\Modules\Invoice\Entities\InvoiceOfflinePayment,checkout_id|id,\Modules\Invoice\Entities\OrderCertificate,checkout_id
     * @mixin _IH_Checkout_QB
     */
    class Checkout extends Model {}
    
    /**
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_GateWay_QB onWriteConnection()
     * @method _IH_GateWay_QB newQuery()
     * @method static _IH_GateWay_QB on(null|string $connection = null)
     * @method static _IH_GateWay_QB query()
     * @method static _IH_GateWay_QB with(array|string $relations)
     * @method _IH_GateWay_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GateWay_C|GateWay[] all()
     * @mixin _IH_GateWay_QB
     */
    class GateWay extends Model {}
    
    /**
     * @property int $id
     * @property int $instructor_id
     * @property float|null $reveune
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $type
     * @property int|null $assign_cpd_course_id
     * @property int|null $class_course_id
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_InstructorPayout_QB onWriteConnection()
     * @method _IH_InstructorPayout_QB newQuery()
     * @method static _IH_InstructorPayout_QB on(null|string $connection = null)
     * @method static _IH_InstructorPayout_QB query()
     * @method static _IH_InstructorPayout_QB with(array|string $relations)
     * @method _IH_InstructorPayout_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstructorPayout_C|InstructorPayout[] all()
     * @ownLinks assign_cpd_course_id,\Modules\CPD\Entities\AssignCpdCourse,id|class_course_id,\Modules\MyClass\Entities\ClassCourse,id
     * @mixin _IH_InstructorPayout_QB
     */
    class InstructorPayout extends Model {}
    
    /**
     * @property int $id
     * @property int $instructor_id
     * @property string $amount
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_InstructorTotalPayout_QB onWriteConnection()
     * @method _IH_InstructorTotalPayout_QB newQuery()
     * @method static _IH_InstructorTotalPayout_QB on(null|string $connection = null)
     * @method static _IH_InstructorTotalPayout_QB query()
     * @method static _IH_InstructorTotalPayout_QB with(array|string $relations)
     * @method _IH_InstructorTotalPayout_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstructorTotalPayout_C|InstructorTotalPayout[] all()
     * @mixin _IH_InstructorTotalPayout_QB
     */
    class InstructorTotalPayout extends Model {}
    
    /**
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property Package $package
     * @method BelongsTo|_IH_Package_QB package()
     * @method static _IH_Subscriber_QB onWriteConnection()
     * @method _IH_Subscriber_QB newQuery()
     * @method static _IH_Subscriber_QB on(null|string $connection = null)
     * @method static _IH_Subscriber_QB query()
     * @method static _IH_Subscriber_QB with(array|string $relations)
     * @method _IH_Subscriber_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Subscriber_C|Subscriber[] all()
     * @mixin _IH_Subscriber_QB
     */
    class Subscriber extends Model {}
    
    /**
     * @property int $id
     * @property int $instructor_id
     * @property float|null $amount
     * @property bool $status
     * @property string $method
     * @property Carbon|null $issueDate
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $invoice_date attribute
     * @property-read $issue_date_format attribute
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Withdraw_QB onWriteConnection()
     * @method _IH_Withdraw_QB newQuery()
     * @method static _IH_Withdraw_QB on(null|string $connection = null)
     * @method static _IH_Withdraw_QB query()
     * @method static _IH_Withdraw_QB with(array|string $relations)
     * @method _IH_Withdraw_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Withdraw_C|Withdraw[] all()
     * @mixin _IH_Withdraw_QB
     */
    class Withdraw extends Model {}
}