<?php //fa792a825a18f90f7f570bf06f108222
/** @noinspection all */

namespace Modules\SkillAndPathway\Entities {

    use App\Models\LmsBadge;
    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsBadge_C;
    use LaravelIdea\Helper\App\Models\_IH_LmsBadge_QB;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseEnrolled_C;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_CourseEnrolled_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\SkillAndPathway\Entities\_IH_GroupStudent_C;
    use LaravelIdea\Helper\Modules\SkillAndPathway\Entities\_IH_GroupStudent_QB;
    use LaravelIdea\Helper\Modules\SkillAndPathway\Entities\_IH_Group_C;
    use LaravelIdea\Helper\Modules\SkillAndPathway\Entities\_IH_Group_QB;
    use LaravelIdea\Helper\Modules\SkillAndPathway\Entities\_IH_PathwayCourse_C;
    use LaravelIdea\Helper\Modules\SkillAndPathway\Entities\_IH_PathwayCourse_QB;
    use LaravelIdea\Helper\Modules\SkillAndPathway\Entities\_IH_Pathway_C;
    use LaravelIdea\Helper\Modules\SkillAndPathway\Entities\_IH_Pathway_QB;
    use LaravelIdea\Helper\Modules\SkillAndPathway\Entities\_IH_Skill_C;
    use LaravelIdea\Helper\Modules\SkillAndPathway\Entities\_IH_Skill_QB;
    use LaravelIdea\Helper\Modules\SkillAndPathway\Entities\_IH_StudentCompletePathway_C;
    use LaravelIdea\Helper\Modules\SkillAndPathway\Entities\_IH_StudentCompletePathway_QB;
    use LaravelIdea\Helper\Modules\SkillAndPathway\Entities\_IH_StudentSkill_C;
    use LaravelIdea\Helper\Modules\SkillAndPathway\Entities\_IH_StudentSkill_QB;
    use Modules\CourseSetting\Entities\Course;
    use Modules\CourseSetting\Entities\CourseEnrolled;
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $description
     * @property int|null $parent_id
     * @property int|null $created_by
     * @property int|null $status
     * @property string|null $course_ids
     * @property int|null $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Group_C|Group[] $childGroups
     * @property-read int $child_groups_count
     * @method HasMany|_IH_Group_QB childGroups()
     * @property _IH_GroupStudent_C|GroupStudent[] $group_students
     * @property-read int $group_students_count
     * @method HasMany|_IH_GroupStudent_QB group_students()
     * @property LmsInstitute|null $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_Group_QB onWriteConnection()
     * @method _IH_Group_QB newQuery()
     * @method static _IH_Group_QB on(null|string $connection = null)
     * @method static _IH_Group_QB query()
     * @method static _IH_Group_QB with(array|string $relations)
     * @method _IH_Group_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Group_C|Group[] all()
     * @mixin _IH_Group_QB
     */
    class Group extends Model {}
    
    /**
     * @property int $id
     * @property int $group_id
     * @property int $student_id
     * @property int|null $added_by
     * @property int|null $status
     * @property int|null $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute|null $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User $student
     * @method BelongsTo|_IH_User_QB student()
     * @method static _IH_GroupStudent_QB onWriteConnection()
     * @method _IH_GroupStudent_QB newQuery()
     * @method static _IH_GroupStudent_QB on(null|string $connection = null)
     * @method static _IH_GroupStudent_QB query()
     * @method static _IH_GroupStudent_QB with(array|string $relations)
     * @method _IH_GroupStudent_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GroupStudent_C|GroupStudent[] all()
     * @ownLinks group_id,\Modules\Group\Entities\Group,id
     * @mixin _IH_GroupStudent_QB
     */
    class GroupStudent extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $description
     * @property string|null $student_ids
     * @property string|null $group_ids
     * @property int|null $group_type
     * @property int|null $status
     * @property int|null $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_LmsBadge_C|LmsBadge[] $badges
     * @property-read int $badges_count
     * @method MorphToMany|_IH_LmsBadge_QB badges()
     * @property _IH_CourseEnrolled_C|CourseEnrolled[] $enrolled
     * @property-read int $enrolled_count
     * @method HasMany|_IH_CourseEnrolled_QB enrolled()
     * @property LmsInstitute|null $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_PathwayCourse_C|PathwayCourse[] $pathwayCourse
     * @property-read int $pathway_course_count
     * @method HasMany|_IH_PathwayCourse_QB pathwayCourse()
     * @property _IH_StudentCompletePathway_C|StudentCompletePathway[] $pathwayCourseComplete
     * @property-read int $pathway_course_complete_count
     * @method HasMany|_IH_StudentCompletePathway_QB pathwayCourseComplete()
     * @method static _IH_Pathway_QB onWriteConnection()
     * @method _IH_Pathway_QB newQuery()
     * @method static _IH_Pathway_QB on(null|string $connection = null)
     * @method static _IH_Pathway_QB query()
     * @method static _IH_Pathway_QB with(array|string $relations)
     * @method _IH_Pathway_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Pathway_C|Pathway[] all()
     * @foreignLinks id,\Modules\CourseSetting\Entities\CourseEnrolled,pathway_id|id,\Modules\SkillAndPathway\Entities\StudentSkill,pathway_id|id,\Modules\SkillAndPathway\Entities\PathwayCourse,pathway_id|id,\Modules\SkillAndPathway\Entities\StudentCompletePathway,pathway_id
     * @mixin _IH_Pathway_QB
     */
    class Pathway extends Model {}
    
    /**
     * @property int $id
     * @property int $pathway_id
     * @property int $course_id
     * @property int|null $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property LmsInstitute|null $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property Pathway $pathway
     * @method BelongsTo|_IH_Pathway_QB pathway()
     * @method static _IH_PathwayCourse_QB onWriteConnection()
     * @method _IH_PathwayCourse_QB newQuery()
     * @method static _IH_PathwayCourse_QB on(null|string $connection = null)
     * @method static _IH_PathwayCourse_QB query()
     * @method static _IH_PathwayCourse_QB with(array|string $relations)
     * @method _IH_PathwayCourse_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PathwayCourse_C|PathwayCourse[] all()
     * @ownLinks pathway_id,\Modules\SkillAndPathway\Entities\Pathway,id|course_id,\Modules\CourseSetting\Entities\Course,id
     * @mixin _IH_PathwayCourse_QB
     */
    class PathwayCourse extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $description
     * @property string|null $badge
     * @property int|null $status
     * @property int $type
     * @property int|null $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_LmsBadge_C|LmsBadge[] $badges
     * @property-read int $badges_count
     * @method MorphToMany|_IH_LmsBadge_QB badges()
     * @property _IH_LmsBadge_C|LmsBadge[] $courses
     * @property-read int $courses_count
     * @method HasMany|_IH_LmsBadge_QB courses()
     * @property LmsInstitute|null $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_LmsBadge_C|LmsBadge[] $pathways
     * @property-read int $pathways_count
     * @method HasMany|_IH_LmsBadge_QB pathways()
     * @method static _IH_Skill_QB onWriteConnection()
     * @method _IH_Skill_QB newQuery()
     * @method static _IH_Skill_QB on(null|string $connection = null)
     * @method static _IH_Skill_QB query()
     * @method static _IH_Skill_QB with(array|string $relations)
     * @method _IH_Skill_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Skill_C|Skill[] all()
     * @foreignLinks id,\App\Models\LmsBadge,skill_id|id,\Modules\SkillAndPathway\Entities\StudentSkill,skill_id
     * @mixin _IH_Skill_QB
     */
    class Skill extends Model {}
    
    /**
     * @property int $id
     * @property int $student_id
     * @property int $pathway_id
     * @property int|null $course_count
     * @property int $course_id
     * @property int|null $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute|null $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_StudentCompletePathway_QB onWriteConnection()
     * @method _IH_StudentCompletePathway_QB newQuery()
     * @method static _IH_StudentCompletePathway_QB on(null|string $connection = null)
     * @method static _IH_StudentCompletePathway_QB query()
     * @method static _IH_StudentCompletePathway_QB with(array|string $relations)
     * @method _IH_StudentCompletePathway_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_StudentCompletePathway_C|StudentCompletePathway[] all()
     * @ownLinks pathway_id,\Modules\SkillAndPathway\Entities\Pathway,id|course_id,\Modules\CourseSetting\Entities\Course,id
     * @mixin _IH_StudentCompletePathway_QB
     */
    class StudentCompletePathway extends Model {}
    
    /**
     * @property int $id
     * @property int $student_id
     * @property int|null $course_id
     * @property int|null $pathway_id
     * @property int|null $skill_id
     * @property int|null $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute|null $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property Skill|null $skill_info
     * @method BelongsTo|_IH_Skill_QB skill_info()
     * @method static _IH_StudentSkill_QB onWriteConnection()
     * @method _IH_StudentSkill_QB newQuery()
     * @method static _IH_StudentSkill_QB on(null|string $connection = null)
     * @method static _IH_StudentSkill_QB query()
     * @method static _IH_StudentSkill_QB with(array|string $relations)
     * @method _IH_StudentSkill_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_StudentSkill_C|StudentSkill[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id|pathway_id,\Modules\SkillAndPathway\Entities\Pathway,id|skill_id,\Modules\SkillAndPathway\Entities\Skill,id
     * @mixin _IH_StudentSkill_QB
     */
    class StudentSkill extends Model {}
}