<?php //1bec8a88dad49dc94e19030292c79e1f
/** @noinspection all */

namespace Modules\Membership\Entities {

    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Certificate\Entities\_IH_CertificateRecord_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\ELibrary\Entities\_IH_Ebook_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_AddCourseToPlan_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_AddCourseToPlan_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_AddEbookToPlan_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_AddEbookToPlan_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_AddMember_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_AddMember_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_CourseMember_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_CourseMember_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_EbookPlanCart_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_EbookPlanCart_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_EbookPlanCheckOut_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_EbookPlanCheckOut_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_EbookPlanEbook_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_EbookPlanEbook_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_EbookPlan_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_EbookPlan_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_LevelForum_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_LevelForum_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_LevelGroupMember_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_LevelGroupMember_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_LevelGroup_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_LevelGroup_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_LiveClassMember_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_LiveClassMember_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipCart_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipCart_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipLevel_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipLevel_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipMember_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipMember_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipPlanCheckout_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipPlanCheckout_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipPlan_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipPlan_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipSettings_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipSettings_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipSubscriptionRenew_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipSubscriptionRenew_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipSubscription_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipSubscription_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipUpgradeLevel_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_MembershipUpgradeLevel_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_PlanLevel_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_PlanLevel_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_RegisterMemberQualification_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_RegisterMemberQualification_QB;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_RegisterMembership_C;
    use LaravelIdea\Helper\Modules\Membership\Entities\_IH_RegisterMembership_QB;
    use Modules\Certificate\Entities\CertificateRecord;
    use Modules\CourseSetting\Entities\Course;
    use Modules\ELibrary\Entities\Ebook;
    
    /**
     * @property int $id
     * @property int|null $course_id
     * @property int|null $plan_id
     * @property int|null $user_id
     * @property int|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property User|null $userInfo
     * @method BelongsTo|_IH_User_QB userInfo()
     * @method static _IH_AddCourseToPlan_QB onWriteConnection()
     * @method _IH_AddCourseToPlan_QB newQuery()
     * @method static _IH_AddCourseToPlan_QB on(null|string $connection = null)
     * @method static _IH_AddCourseToPlan_QB query()
     * @method static _IH_AddCourseToPlan_QB with(array|string $relations)
     * @method _IH_AddCourseToPlan_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AddCourseToPlan_C|AddCourseToPlan[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_AddCourseToPlan_QB
     */
    class AddCourseToPlan extends Model {}
    
    /**
     * @property int $id
     * @property int|null $ebook_id
     * @property int|null $plan_id
     * @property int|null $user_id
     * @property int|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Ebook|null $ebook
     * @method BelongsTo|_IH_Ebook_QB ebook()
     * @property User|null $userInfo
     * @method BelongsTo|_IH_User_QB userInfo()
     * @method static _IH_AddEbookToPlan_QB onWriteConnection()
     * @method _IH_AddEbookToPlan_QB newQuery()
     * @method static _IH_AddEbookToPlan_QB on(null|string $connection = null)
     * @method static _IH_AddEbookToPlan_QB query()
     * @method static _IH_AddEbookToPlan_QB with(array|string $relations)
     * @method _IH_AddEbookToPlan_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AddEbookToPlan_C|AddEbookToPlan[] all()
     * @ownLinks ebook_id,\Modules\ELibrary\Entities\Ebook,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_AddEbookToPlan_QB
     */
    class AddEbookToPlan extends Model {}
    
    /**
     * @property int $id
     * @property int|null $plan_id
     * @property int|null $user_id
     * @property int|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_AddMember_QB onWriteConnection()
     * @method _IH_AddMember_QB newQuery()
     * @method static _IH_AddMember_QB on(null|string $connection = null)
     * @method static _IH_AddMember_QB query()
     * @method static _IH_AddMember_QB with(array|string $relations)
     * @method _IH_AddMember_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AddMember_C|AddMember[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_AddMember_QB
     */
    class AddMember extends Model {}
    
    /**
     * @property int $id
     * @property int|null $course_id
     * @property int|null $membership_level_id
     * @property int|null $user_id
     * @property int|null $created_by
     * @property int|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_CourseMember_QB onWriteConnection()
     * @method _IH_CourseMember_QB newQuery()
     * @method static _IH_CourseMember_QB on(null|string $connection = null)
     * @method static _IH_CourseMember_QB query()
     * @method static _IH_CourseMember_QB with(array|string $relations)
     * @method _IH_CourseMember_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CourseMember_C|CourseMember[] all()
     * @ownLinks membership_level_id,\Modules\Membership\Entities\MembershipLevel,id|course_id,\Modules\CourseSetting\Entities\Course,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_CourseMember_QB
     */
    class CourseMember extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property float $price
     * @property string|null $about
     * @property int|null $days
     * @property bool $status
     * @property int $order
     * @property string $button_text
     * @property int $student
     * @property int $user_id
     * @property int $reveune
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property EbookPlanCheckOut $checkout
     * @method BelongsTo|_IH_EbookPlanCheckOut_QB checkout()
     * @property _IH_EbookPlanEbook_C|EbookPlanEbook[] $ebooks
     * @property-read int $ebooks_count
     * @method HasMany|_IH_EbookPlanEbook_QB ebooks()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_EbookPlan_QB onWriteConnection()
     * @method _IH_EbookPlan_QB newQuery()
     * @method static _IH_EbookPlan_QB on(null|string $connection = null)
     * @method static _IH_EbookPlan_QB query()
     * @method static _IH_EbookPlan_QB with(array|string $relations)
     * @method _IH_EbookPlan_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EbookPlan_C|EbookPlan[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @foreignLinks id,\Modules\Membership\Entities\EbookPlanEbook,ebook_plan_id|id,\Modules\Membership\Entities\EbookPlanCart,ebook_plan_id|id,\Modules\Membership\Entities\EbookPlanCheckOut,ebook_plan_id
     * @mixin _IH_EbookPlan_QB
     */
    class EbookPlan extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $ebook_plan_id
     * @property int $price
     * @property int $days
     * @property string $tracking
     * @property string|null $billing_detail_id
     * @property string|null $type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property EbookPlan $plan
     * @method BelongsTo|_IH_EbookPlan_QB plan()
     * @method static _IH_EbookPlanCart_QB onWriteConnection()
     * @method _IH_EbookPlanCart_QB newQuery()
     * @method static _IH_EbookPlanCart_QB on(null|string $connection = null)
     * @method static _IH_EbookPlanCart_QB query()
     * @method static _IH_EbookPlanCart_QB with(array|string $relations)
     * @method _IH_EbookPlanCart_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EbookPlanCart_C|EbookPlanCart[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|ebook_plan_id,\Modules\Membership\Entities\EbookPlan,id|billing_detail_id,\App\BillingDetails,id
     * @mixin _IH_EbookPlanCart_QB
     */
    class EbookPlanCart extends Model {}
    
    /**
     * @property int $id
     * @property int $billing_detail_id
     * @property string|null $tracking
     * @property int|null $user_id
     * @property int|null $ebook_plan_id
     * @property int $price
     * @property float $discount
     * @property float|null $purchase_price
     * @property int|null $coupon_id
     * @property Carbon|null $start_date
     * @property Carbon|null $end_date
     * @property int $days
     * @property string|null $payment_method
     * @property string|null $response
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property EbookPlan|null $plan
     * @method BelongsTo|_IH_EbookPlan_QB plan()
     * @method static _IH_EbookPlanCheckOut_QB onWriteConnection()
     * @method _IH_EbookPlanCheckOut_QB newQuery()
     * @method static _IH_EbookPlanCheckOut_QB on(null|string $connection = null)
     * @method static _IH_EbookPlanCheckOut_QB query()
     * @method static _IH_EbookPlanCheckOut_QB with(array|string $relations)
     * @method _IH_EbookPlanCheckOut_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EbookPlanCheckOut_C|EbookPlanCheckOut[] all()
     * @ownLinks billing_detail_id,\App\BillingDetails,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|ebook_plan_id,\Modules\Membership\Entities\EbookPlan,id|coupon_id,\Modules\Coupons\Entities\Coupon,id
     * @mixin _IH_EbookPlanCheckOut_QB
     */
    class EbookPlanCheckOut extends Model {}
    
    /**
     * @property int $id
     * @property int $ebook_plan_id
     * @property int $ebook_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Ebook $ebook
     * @method BelongsTo|_IH_Ebook_QB ebook()
     * @property EbookPlan $ebookPlan
     * @method BelongsTo|_IH_EbookPlan_QB ebookPlan()
     * @method static _IH_EbookPlanEbook_QB onWriteConnection()
     * @method _IH_EbookPlanEbook_QB newQuery()
     * @method static _IH_EbookPlanEbook_QB on(null|string $connection = null)
     * @method static _IH_EbookPlanEbook_QB query()
     * @method static _IH_EbookPlanEbook_QB with(array|string $relations)
     * @method _IH_EbookPlanEbook_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EbookPlanEbook_C|EbookPlanEbook[] all()
     * @ownLinks ebook_plan_id,\Modules\Membership\Entities\EbookPlan,id|ebook_id,\Modules\ELibrary\Entities\Ebook,id
     * @mixin _IH_EbookPlanEbook_QB
     */
    class EbookPlanEbook extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property int|null $membership_level_id
     * @property int|null $created_by
     * @property int|null $status
     * @property string|null $body
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @method static _IH_LevelForum_QB onWriteConnection()
     * @method _IH_LevelForum_QB newQuery()
     * @method static _IH_LevelForum_QB on(null|string $connection = null)
     * @method static _IH_LevelForum_QB query()
     * @method static _IH_LevelForum_QB with(array|string $relations)
     * @method _IH_LevelForum_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_LevelForum_C|LevelForum[] all()
     * @ownLinks membership_level_id,\Modules\Membership\Entities\MembershipLevel,id|created_by,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_LevelForum_QB
     */
    class LevelForum extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property int $membership_level_id
     * @property int|null $created_by
     * @property int|null $status
     * @property string|null $body
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @method static _IH_LevelGroup_QB onWriteConnection()
     * @method _IH_LevelGroup_QB newQuery()
     * @method static _IH_LevelGroup_QB on(null|string $connection = null)
     * @method static _IH_LevelGroup_QB query()
     * @method static _IH_LevelGroup_QB with(array|string $relations)
     * @method _IH_LevelGroup_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_LevelGroup_C|LevelGroup[] all()
     * @ownLinks membership_level_id,\Modules\Membership\Entities\MembershipLevel,id
     * @mixin _IH_LevelGroup_QB
     */
    class LevelGroup extends Model {}
    
    /**
     * @property int $id
     * @property int $group_id
     * @property int $user_id
     * @property int|null $user_role_id
     * @property string|null $instructor_role
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_LevelGroupMember_QB onWriteConnection()
     * @method _IH_LevelGroupMember_QB newQuery()
     * @method static _IH_LevelGroupMember_QB on(null|string $connection = null)
     * @method static _IH_LevelGroupMember_QB query()
     * @method static _IH_LevelGroupMember_QB with(array|string $relations)
     * @method _IH_LevelGroupMember_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_LevelGroupMember_C|LevelGroupMember[] all()
     * @ownLinks group_id,\Modules\Group\Entities\Group,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|user_role_id,\Modules\UserType\Entities\UserRole,id
     * @mixin _IH_LevelGroupMember_QB
     */
    class LevelGroupMember extends Model {}
    
    /**
     * @property int $id
     * @property int|null $virtual_class_id
     * @property int|null $membership_level_id
     * @property int|null $user_id
     * @property int|null $created_by
     * @property int|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_LiveClassMember_QB onWriteConnection()
     * @method _IH_LiveClassMember_QB newQuery()
     * @method static _IH_LiveClassMember_QB on(null|string $connection = null)
     * @method static _IH_LiveClassMember_QB query()
     * @method static _IH_LiveClassMember_QB with(array|string $relations)
     * @method _IH_LiveClassMember_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_LiveClassMember_C|LiveClassMember[] all()
     * @ownLinks membership_level_id,\Modules\Membership\Entities\MembershipLevel,id|virtual_class_id,\Modules\VirtualClass\Entities\VirtualClass,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_LiveClassMember_QB
     */
    class LiveClassMember extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $plan_id
     * @property int $price
     * @property int|null $days
     * @property string $tracking
     * @property string|null $billing_detail_id
     * @property string|null $type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property MembershipPlan $plan
     * @method BelongsTo|_IH_MembershipPlan_QB plan()
     * @method static _IH_MembershipCart_QB onWriteConnection()
     * @method _IH_MembershipCart_QB newQuery()
     * @method static _IH_MembershipCart_QB on(null|string $connection = null)
     * @method static _IH_MembershipCart_QB query()
     * @method static _IH_MembershipCart_QB with(array|string $relations)
     * @method _IH_MembershipCart_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MembershipCart_C|MembershipCart[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|billing_detail_id,\App\BillingDetails,id
     * @mixin _IH_MembershipCart_QB
     */
    class MembershipCart extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property int|null $user_id
     * @property int|null $status
     * @property int|null $price
     * @property bool|null $is_paid
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @method static _IH_MembershipLevel_QB onWriteConnection()
     * @method _IH_MembershipLevel_QB newQuery()
     * @method static _IH_MembershipLevel_QB on(null|string $connection = null)
     * @method static _IH_MembershipLevel_QB query()
     * @method static _IH_MembershipLevel_QB with(array|string $relations)
     * @method _IH_MembershipLevel_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MembershipLevel_C|MembershipLevel[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @foreignLinks id,\Modules\Membership\Entities\LevelForum,membership_level_id|id,\Modules\CourseSetting\Entities\Course,membership_level_id|id,\Modules\Membership\Entities\CourseMember,membership_level_id|id,\Modules\VirtualClass\Entities\VirtualClass,membership_level_id|id,\Modules\Membership\Entities\LiveClassMember,membership_level_id|id,\Modules\Group\Entities\Group,membership_level_id|id,\Modules\Group\Entities\GroupMember,membership_level_id|id,\Modules\Membership\Entities\LevelGroup,membership_level_id|id,\Modules\Membership\Entities\PlanLevel,membership_level_id
     * @mixin _IH_MembershipLevel_QB
     */
    class MembershipLevel extends Model {}
    
    /**
     * @property int $id
     * @property int|null $tracking
     * @property int|null $member_id
     * @property int|null $plan_id
     * @property int|null $user_id
     * @property float $discount
     * @property float|null $purchase_price
     * @property float|null $price
     * @property bool $status
     * @property string|null $payment_method
     * @property string|null $response
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User|null $createdBy
     * @method BelongsTo|_IH_User_QB createdBy()
     * @property User|null $member
     * @method BelongsTo|_IH_User_QB member()
     * @property MembershipPlan|null $plan
     * @method BelongsTo|_IH_MembershipPlan_QB plan()
     * @method static _IH_MembershipMember_QB onWriteConnection()
     * @method _IH_MembershipMember_QB newQuery()
     * @method static _IH_MembershipMember_QB on(null|string $connection = null)
     * @method static _IH_MembershipMember_QB query()
     * @method static _IH_MembershipMember_QB with(array|string $relations)
     * @method _IH_MembershipMember_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MembershipMember_C|MembershipMember[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_MembershipMember_QB
     */
    class MembershipMember extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $price
     * @property int|null $level_id
     * @property int|null $user_id
     * @property int|null $status
     * @property int|null $position_order
     * @property int|null $expire_after
     * @property string|null $expire_type
     * @property int|null $expire
     * @property string|null $detail
     * @property string|null $btn_txt
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property _IH_AddCourseToPlan_C|AddCourseToPlan[] $courses
     * @property-read int $courses_count
     * @method HasMany|_IH_AddCourseToPlan_QB courses()
     * @property _IH_AddEbookToPlan_C|AddEbookToPlan[] $ebooks
     * @property-read int $ebooks_count
     * @method HasMany|_IH_AddEbookToPlan_QB ebooks()
     * @property MembershipLevel|null $level
     * @method BelongsTo|_IH_MembershipLevel_QB level()
     * @property _IH_MembershipPlanCheckout_C|MembershipPlanCheckout[] $students
     * @property-read int $students_count
     * @method HasMany|_IH_MembershipPlanCheckout_QB students()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_MembershipPlan_QB onWriteConnection()
     * @method _IH_MembershipPlan_QB newQuery()
     * @method static _IH_MembershipPlan_QB on(null|string $connection = null)
     * @method static _IH_MembershipPlan_QB query()
     * @method static _IH_MembershipPlan_QB with(array|string $relations)
     * @method _IH_MembershipPlan_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MembershipPlan_C|MembershipPlan[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @foreignLinks id,\Modules\Certificate\Entities\CertificateRecord,membership_plan_id|id,\Modules\Membership\Entities\PlanLevel,membership_plan_id
     * @mixin _IH_MembershipPlan_QB
     */
    class MembershipPlan extends Model {}
    
    /**
     * @property int $id
     * @property int $billing_detail_id
     * @property string|null $tracking
     * @property int|null $user_id
     * @property int|null $plan_id
     * @property int $price
     * @property float $discount
     * @property float|null $purchase_price
     * @property int|null $coupon_id
     * @property int|null $tax
     * @property Carbon|null $start_date
     * @property Carbon|null $end_date
     * @property bool|null $is_renew
     * @property int $days
     * @property string|null $payment_method
     * @property string|null $response
     * @property int $status
     * @property int|null $current_level
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property CertificateRecord|null $hasCertificate
     * @method HasOne|_IH_CertificateRecord_QB hasCertificate()
     * @property MembershipPlan|null $plan
     * @method BelongsTo|_IH_MembershipPlan_QB plan()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_MembershipPlanCheckout_QB onWriteConnection()
     * @method _IH_MembershipPlanCheckout_QB newQuery()
     * @method static _IH_MembershipPlanCheckout_QB on(null|string $connection = null)
     * @method static _IH_MembershipPlanCheckout_QB query()
     * @method static _IH_MembershipPlanCheckout_QB with(array|string $relations)
     * @method _IH_MembershipPlanCheckout_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MembershipPlanCheckout_C|MembershipPlanCheckout[] all()
     * @ownLinks billing_detail_id,\App\BillingDetails,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|coupon_id,\Modules\Coupons\Entities\Coupon,id
     * @mixin _IH_MembershipPlanCheckout_QB
     */
    class MembershipPlanCheckout extends Model {}
    
    /**
     * @property int $id
     * @property string|null $expire_type
     * @property int|null $expire_number
     * @property int|null $renew_before
     * @property int|null $lms_id
     * @property bool|null $approval_system
     * @property string|null $membership_prefix
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_MembershipSettings_QB onWriteConnection()
     * @method _IH_MembershipSettings_QB newQuery()
     * @method static _IH_MembershipSettings_QB on(null|string $connection = null)
     * @method static _IH_MembershipSettings_QB query()
     * @method static _IH_MembershipSettings_QB with(array|string $relations)
     * @method _IH_MembershipSettings_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MembershipSettings_C|MembershipSettings[] all()
     * @mixin _IH_MembershipSettings_QB
     */
    class MembershipSettings extends Model {}
    
    /**
     * @property int $id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_MembershipSubscription_QB onWriteConnection()
     * @method _IH_MembershipSubscription_QB newQuery()
     * @method static _IH_MembershipSubscription_QB on(null|string $connection = null)
     * @method static _IH_MembershipSubscription_QB query()
     * @method static _IH_MembershipSubscription_QB with(array|string $relations)
     * @method _IH_MembershipSubscription_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MembershipSubscription_C|MembershipSubscription[] all()
     * @mixin _IH_MembershipSubscription_QB
     */
    class MembershipSubscription extends Model {}
    
    /**
     * @property int $id
     * @property int $membership_checkout_id
     * @property int $price
     * @property float $discount
     * @property float|null $purchase_price
     * @property int|null $coupon_id
     * @property Carbon|null $start_date
     * @property Carbon|null $end_date
     * @property string|null $payment_method
     * @property string|null $response
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_MembershipSubscriptionRenew_QB onWriteConnection()
     * @method _IH_MembershipSubscriptionRenew_QB newQuery()
     * @method static _IH_MembershipSubscriptionRenew_QB on(null|string $connection = null)
     * @method static _IH_MembershipSubscriptionRenew_QB query()
     * @method static _IH_MembershipSubscriptionRenew_QB with(array|string $relations)
     * @method _IH_MembershipSubscriptionRenew_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MembershipSubscriptionRenew_C|MembershipSubscriptionRenew[] all()
     * @ownLinks coupon_id,\Modules\Coupons\Entities\Coupon,id
     * @mixin _IH_MembershipSubscriptionRenew_QB
     */
    class MembershipSubscriptionRenew extends Model {}
    
    /**
     * @property int $id
     * @property int|null $membership_checkout_id
     * @property int|null $level_id
     * @property int|null $user_id
     * @property int|null $price
     * @property float $discount
     * @property float|null $purchase_price
     * @property int|null $coupon_id
     * @property string|null $payment_method
     * @property string|null $response
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property MembershipLevel $level
     * @method BelongsTo|_IH_MembershipLevel_QB level()
     * @property MembershipPlan $plan
     * @method BelongsTo|_IH_MembershipPlan_QB plan()
     * @method static _IH_MembershipUpgradeLevel_QB onWriteConnection()
     * @method _IH_MembershipUpgradeLevel_QB newQuery()
     * @method static _IH_MembershipUpgradeLevel_QB on(null|string $connection = null)
     * @method static _IH_MembershipUpgradeLevel_QB query()
     * @method static _IH_MembershipUpgradeLevel_QB with(array|string $relations)
     * @method _IH_MembershipUpgradeLevel_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_MembershipUpgradeLevel_C|MembershipUpgradeLevel[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|coupon_id,\Modules\Coupons\Entities\Coupon,id
     * @mixin _IH_MembershipUpgradeLevel_QB
     */
    class MembershipUpgradeLevel extends Model {}
    
    /**
     * @property int $id
     * @property int|null $membership_plan_id
     * @property int|null $membership_level_id
     * @property int|null $price
     * @property bool|null $is_paid
     * @property int|null $status
     * @property int|null $position_id
     * @property int|null $created_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property MembershipLevel|null $level
     * @method BelongsTo|_IH_MembershipLevel_QB level()
     * @property MembershipPlan|null $plan
     * @method BelongsTo|_IH_MembershipPlan_QB plan()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_PlanLevel_QB onWriteConnection()
     * @method _IH_PlanLevel_QB newQuery()
     * @method static _IH_PlanLevel_QB on(null|string $connection = null)
     * @method static _IH_PlanLevel_QB query()
     * @method static _IH_PlanLevel_QB with(array|string $relations)
     * @method _IH_PlanLevel_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PlanLevel_C|PlanLevel[] all()
     * @ownLinks membership_plan_id,\Modules\Membership\Entities\MembershipPlan,id|membership_level_id,\Modules\Membership\Entities\MembershipLevel,id
     * @mixin _IH_PlanLevel_QB
     */
    class PlanLevel extends Model {}
    
    /**
     * @property int $id
     * @property int|null $register_membership_id
     * @property string|null $qualification_file
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_RegisterMemberQualification_QB onWriteConnection()
     * @method _IH_RegisterMemberQualification_QB newQuery()
     * @method static _IH_RegisterMemberQualification_QB on(null|string $connection = null)
     * @method static _IH_RegisterMemberQualification_QB query()
     * @method static _IH_RegisterMemberQualification_QB with(array|string $relations)
     * @method _IH_RegisterMemberQualification_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RegisterMemberQualification_C|RegisterMemberQualification[] all()
     * @ownLinks register_membership_id,\Modules\Membership\Entities\RegisterMembership,id
     * @mixin _IH_RegisterMemberQualification_QB
     */
    class RegisterMemberQualification extends Model {}
    
    /**
     * @property int $id
     * @property string|null $first_name
     * @property string|null $last_name
     * @property string|null $phone_number
     * @property string|null $cv
     * @property string $email
     * @property string $password
     * @property Carbon|null $approved_date
     * @property int|null $approved_by
     * @property int|null $user_id
     * @property bool|null $is_member
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User|null $approvedBy
     * @method BelongsTo|_IH_User_QB approvedBy()
     * @property _IH_RegisterMemberQualification_C|RegisterMemberQualification[] $qualifications
     * @property-read int $qualifications_count
     * @method HasMany|_IH_RegisterMemberQualification_QB qualifications()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_RegisterMembership_QB onWriteConnection()
     * @method _IH_RegisterMembership_QB newQuery()
     * @method static _IH_RegisterMembership_QB on(null|string $connection = null)
     * @method static _IH_RegisterMembership_QB query()
     * @method static _IH_RegisterMembership_QB with(array|string $relations)
     * @method _IH_RegisterMembership_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RegisterMembership_C|RegisterMembership[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @foreignLinks id,\Modules\Membership\Entities\RegisterMemberQualification,register_membership_id
     * @mixin _IH_RegisterMembership_QB
     */
    class RegisterMembership extends Model {}
}