<?php //a8e4bae082d2a538235281e9cfe2e7a7
/** @noinspection all */

namespace Modules\OrgInstructorPolicy\Entities {

    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_C;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\Org\Entities\_IH_OrgBranch_QB;
    use LaravelIdea\Helper\Modules\OrgInstructorPolicy\Entities\_IH_OrgPolicyBranch_C;
    use LaravelIdea\Helper\Modules\OrgInstructorPolicy\Entities\_IH_OrgPolicyBranch_QB;
    use LaravelIdea\Helper\Modules\OrgInstructorPolicy\Entities\_IH_OrgPolicyCategory_C;
    use LaravelIdea\Helper\Modules\OrgInstructorPolicy\Entities\_IH_OrgPolicyCategory_QB;
    use LaravelIdea\Helper\Modules\OrgInstructorPolicy\Entities\_IH_OrgPolicyCourseList_C;
    use LaravelIdea\Helper\Modules\OrgInstructorPolicy\Entities\_IH_OrgPolicyCourseList_QB;
    use LaravelIdea\Helper\Modules\OrgInstructorPolicy\Entities\_IH_OrgPolicy_C;
    use LaravelIdea\Helper\Modules\OrgInstructorPolicy\Entities\_IH_OrgPolicy_QB;
    use LaravelIdea\Helper\Modules\RolePermission\Entities\_IH_Permission_C;
    use LaravelIdea\Helper\Modules\RolePermission\Entities\_IH_Permission_QB;
    use Modules\CourseSetting\Entities\Course;
    use Modules\Org\Entities\OrgBranch;
    use Modules\RolePermission\Entities\Permission;
    
    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_OrgPolicyBranch_C|OrgPolicyBranch[] $branches
     * @property-read int $branches_count
     * @method HasMany|_IH_OrgPolicyBranch_QB branches()
     * @property _IH_OrgPolicyCategory_C|OrgPolicyCategory[] $categories
     * @property-read int $categories_count
     * @method HasMany|_IH_OrgPolicyCategory_QB categories()
     * @property _IH_OrgPolicyCourseList_C|OrgPolicyCourseList[] $course_assigns
     * @property-read int $course_assigns_count
     * @method HasMany|_IH_OrgPolicyCourseList_QB course_assigns()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_User_C|User[] $instructors
     * @property-read int $instructors_count
     * @method HasMany|_IH_User_QB instructors()
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method BelongsToMany|_IH_Permission_QB permissions()
     * @method static _IH_OrgPolicy_QB onWriteConnection()
     * @method _IH_OrgPolicy_QB newQuery()
     * @method static _IH_OrgPolicy_QB on(null|string $connection = null)
     * @method static _IH_OrgPolicy_QB query()
     * @method static _IH_OrgPolicy_QB with(array|string $relations)
     * @method _IH_OrgPolicy_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrgPolicy_C|OrgPolicy[] all()
     * @mixin _IH_OrgPolicy_QB
     */
    class OrgPolicy extends Model {}
    
    /**
     * @property int $id
     * @property int $policy_id
     * @property int $branch_id
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property OrgBranch $branch
     * @method BelongsTo|_IH_OrgBranch_QB branch()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property OrgPolicy $policy
     * @method BelongsTo|_IH_OrgPolicy_QB policy()
     * @method static _IH_OrgPolicyBranch_QB onWriteConnection()
     * @method _IH_OrgPolicyBranch_QB newQuery()
     * @method static _IH_OrgPolicyBranch_QB on(null|string $connection = null)
     * @method static _IH_OrgPolicyBranch_QB query()
     * @method static _IH_OrgPolicyBranch_QB with(array|string $relations)
     * @method _IH_OrgPolicyBranch_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrgPolicyBranch_C|OrgPolicyBranch[] all()
     * @ownLinks branch_id,\Modules\SaasBranch\Entities\Branch,id
     * @mixin _IH_OrgPolicyBranch_QB
     */
    class OrgPolicyBranch extends Model {}
    
    /**
     * @property int $id
     * @property int $policy_id
     * @property int $category_id
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_OrgPolicyCategory_QB onWriteConnection()
     * @method _IH_OrgPolicyCategory_QB newQuery()
     * @method static _IH_OrgPolicyCategory_QB on(null|string $connection = null)
     * @method static _IH_OrgPolicyCategory_QB query()
     * @method static _IH_OrgPolicyCategory_QB with(array|string $relations)
     * @method _IH_OrgPolicyCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrgPolicyCategory_C|OrgPolicyCategory[] all()
     * @ownLinks category_id,\Modules\CourseSetting\Entities\Category,id
     * @mixin _IH_OrgPolicyCategory_QB
     */
    class OrgPolicyCategory extends Model {}
    
    /**
     * @property int $id
     * @property int $course_id
     * @property int $policy_id
     * @property int $order
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property OrgPolicy $policy
     * @method BelongsTo|_IH_OrgPolicy_QB policy()
     * @method static _IH_OrgPolicyCourseList_QB onWriteConnection()
     * @method _IH_OrgPolicyCourseList_QB newQuery()
     * @method static _IH_OrgPolicyCourseList_QB on(null|string $connection = null)
     * @method static _IH_OrgPolicyCourseList_QB query()
     * @method static _IH_OrgPolicyCourseList_QB with(array|string $relations)
     * @method _IH_OrgPolicyCourseList_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrgPolicyCourseList_C|OrgPolicyCourseList[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id
     * @mixin _IH_OrgPolicyCourseList_QB
     */
    class OrgPolicyCourseList extends Model {}
}