<?php //617aad1dd886c63f01152224635c79b5
/** @noinspection all */

namespace Modules\Blog\Entities {

    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\MorphTo;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_C;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_BlogCategory_C;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_BlogCategory_QB;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_BlogCommentRepliesReply_C;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_BlogCommentRepliesReply_QB;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_BlogComment_C;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_BlogComment_QB;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_Blog_C;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_Blog_QB;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_Like_C;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_Like_QB;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_UserBlog_C;
    use LaravelIdea\Helper\Modules\Blog\Entities\_IH_UserBlog_QB;
    use LaravelIdea\Helper\Modules\Org\Entities\_IH_OrgBlogBranch_C;
    use LaravelIdea\Helper\Modules\Org\Entities\_IH_OrgBlogBranch_QB;
    use LaravelIdea\Helper\Modules\Org\Entities\_IH_OrgBlogPosition_C;
    use LaravelIdea\Helper\Modules\Org\Entities\_IH_OrgBlogPosition_QB;
    use Modules\Org\Entities\OrgBlogBranch;
    use Modules\Org\Entities\OrgBlogPosition;
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string|null $title
     * @property string $slug
     * @property string|null $description
     * @property bool $status
     * @property string $image
     * @property string $thumbnail
     * @property int $viewed
     * @property string $authored_date
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $tags
     * @property int $category_id
     * @property string|null $authored_time
     * @property int $audience
     * @property Carbon|null $authored_date_time
     * @property int $position_audience
     * @property-read mixed[] $translations attribute
     * @property _IH_OrgBlogBranch_C|OrgBlogBranch[] $branches
     * @property-read int $branches_count
     * @method HasMany|_IH_OrgBlogBranch_QB branches()
     * @property BlogCategory $category
     * @method BelongsTo|_IH_BlogCategory_QB category()
     * @property _IH_BlogComment_C|BlogComment[] $comments
     * @property-read int $comments_count
     * @method HasMany|_IH_BlogComment_QB comments()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_User_C|User[] $likers
     * @property-read int $likers_count
     * @method BelongsToMany|_IH_User_QB likers()
     * @property _IH_OrgBlogPosition_C|OrgBlogPosition[] $positions
     * @property-read int $positions_count
     * @method HasMany|_IH_OrgBlogPosition_QB positions()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @property UserBlog $userRead
     * @method HasOne|_IH_UserBlog_QB userRead()
     * @method static _IH_Blog_QB onWriteConnection()
     * @method _IH_Blog_QB newQuery()
     * @method static _IH_Blog_QB on(null|string $connection = null)
     * @method static _IH_Blog_QB query()
     * @method static _IH_Blog_QB with(array|string $relations)
     * @method _IH_Blog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Blog_C|Blog[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|category_id,\Modules\CourseSetting\Entities\Category,id
     * @foreignLinks id,\Modules\Blog\Entities\BlogComment,blog_id|id,\Modules\Org\Entities\OrgBlogBranch,blog_id|id,\Modules\Org\Entities\OrgBlogPosition,blog_id|id,\Modules\Blog\Entities\UserBlog,blog_id|id,\Modules\Blog\Entities\BlogCommentRepliesReply,blog_id
     * @mixin _IH_Blog_QB
     */
    class Blog extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string|null $title
     * @property int $position_order
     * @property bool $status
     * @property int $parent_id
     * @property int $lms_id
     * @property string|null $tags
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read mixed[] $translations attribute
     * @property _IH_BlogCategory_C|BlogCategory[] $childs
     * @property-read int $childs_count
     * @method HasMany|_IH_BlogCategory_QB childs()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property BlogCategory $parent
     * @method BelongsTo|_IH_BlogCategory_QB parent()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_BlogCategory_QB onWriteConnection()
     * @method _IH_BlogCategory_QB newQuery()
     * @method static _IH_BlogCategory_QB on(null|string $connection = null)
     * @method static _IH_BlogCategory_QB query()
     * @method static _IH_BlogCategory_QB with(array|string $relations)
     * @method _IH_BlogCategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BlogCategory_C|BlogCategory[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_BlogCategory_QB
     */
    class BlogCategory extends Model {}
    
    /**
     * @property int $id
     * @property int|null $user_id
     * @property string|null $name
     * @property string|null $email
     * @property string|null $comment
     * @property int|null $comment_id
     * @property int $blog_id
     * @property int $type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $status
     * @property Blog $blog
     * @method BelongsTo|_IH_Blog_QB blog()
     * @property _IH_BlogComment_C|BlogComment[] $replies
     * @property-read int $replies_count
     * @method HasMany|_IH_BlogComment_QB replies()
     * @property _IH_BlogCommentRepliesReply_C|BlogCommentRepliesReply[] $second_replies
     * @property-read int $second_replies_count
     * @method HasMany|_IH_BlogCommentRepliesReply_QB second_replies()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_BlogComment_QB onWriteConnection()
     * @method _IH_BlogComment_QB newQuery()
     * @method static _IH_BlogComment_QB on(null|string $connection = null)
     * @method static _IH_BlogComment_QB query()
     * @method static _IH_BlogComment_QB with(array|string $relations)
     * @method _IH_BlogComment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BlogComment_C|BlogComment[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|blog_id,\Modules\Blog\Entities\Blog,id
     * @mixin _IH_BlogComment_QB
     */
    class BlogComment extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property string|null $name
     * @property string|null $email
     * @property int $blog_id
     * @property int $comment_id
     * @property int $reply_id
     * @property bool $status
     * @property string $reply
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_BlogCommentRepliesReply_QB onWriteConnection()
     * @method _IH_BlogCommentRepliesReply_QB newQuery()
     * @method static _IH_BlogCommentRepliesReply_QB on(null|string $connection = null)
     * @method static _IH_BlogCommentRepliesReply_QB query()
     * @method static _IH_BlogCommentRepliesReply_QB with(array|string $relations)
     * @method _IH_BlogCommentRepliesReply_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BlogCommentRepliesReply_C|BlogCommentRepliesReply[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|blog_id,\Modules\Blog\Entities\Blog,id
     * @mixin _IH_BlogCommentRepliesReply_QB
     */
    class BlogCommentRepliesReply extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $likeable_id
     * @property string $likeable_type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Model $likeable
     * @method MorphTo likeable()
     * @property User $liker
     * @method BelongsTo|_IH_User_QB liker()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Like_QB onWriteConnection()
     * @method _IH_Like_QB newQuery()
     * @method static _IH_Like_QB on(null|string $connection = null)
     * @method static _IH_Like_QB query()
     * @method static _IH_Like_QB with(array|string $relations)
     * @method _IH_Like_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Like_C|Like[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_Like_QB
     */
    class Like extends Model {}
    
    /**
     * @property int $id
     * @property int $blog_id
     * @property int $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_UserBlog_QB onWriteConnection()
     * @method _IH_UserBlog_QB newQuery()
     * @method static _IH_UserBlog_QB on(null|string $connection = null)
     * @method static _IH_UserBlog_QB query()
     * @method static _IH_UserBlog_QB with(array|string $relations)
     * @method _IH_UserBlog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserBlog_C|UserBlog[] all()
     * @ownLinks blog_id,\Modules\Blog\Entities\Blog,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_UserBlog_QB
     */
    class UserBlog extends Model {}
}