<?php //afa9c069729d28c201734366afb0fe55
/** @noinspection all */

namespace Modules\Installment\Entities {

    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_InstallmentCart_C;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_InstallmentCart_QB;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_InstallmentPlanOption_C;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_InstallmentPlanOption_QB;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_InstallmentPlanPaymentStep_C;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_InstallmentPlanPaymentStep_QB;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_InstallmentPlan_C;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_InstallmentPlan_QB;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_InstallmentPurchasePayment_C;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_InstallmentPurchasePayment_QB;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_InstallmentPurchaseRequest_C;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_InstallmentPurchaseRequest_QB;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_InstallmentVerificationAttachment_C;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_InstallmentVerificationAttachment_QB;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_PlanSpecificItemDetails_C;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_PlanSpecificItemDetails_QB;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_PlanSpecificItem_C;
    use LaravelIdea\Helper\Modules\Installment\Entities\_IH_PlanSpecificItem_QB;
    use Modules\CourseSetting\Entities\Course;
    
    /**
     * @property int $id
     * @property int $course_id
     * @property int $user_id
     * @property int $instructor_id
     * @property string $tracking
     * @property float $price
     * @property int $plan_id
     * @property string $step
     * @property string|null $installment_data
     * @property int|null $purchase_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_InstallmentCart_QB onWriteConnection()
     * @method _IH_InstallmentCart_QB newQuery()
     * @method static _IH_InstallmentCart_QB on(null|string $connection = null)
     * @method static _IH_InstallmentCart_QB query()
     * @method static _IH_InstallmentCart_QB with(array|string $relations)
     * @method _IH_InstallmentCart_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstallmentCart_C|InstallmentCart[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_InstallmentCart_QB
     */
    class InstallmentCart extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string|null $description
     * @property string|null $banner
     * @property int|null $capacity
     * @property int|null $sales
     * @property Carbon|null $start_datetime
     * @property Carbon|null $end_datetime
     * @property int|null $verification_required
     * @property string|null $verification_description
     * @property string|null $verification_banner
     * @property string|null $verification_video
     * @property int|null $request_uploads
     * @property int|null $bypass_verification_for_verified_users
     * @property int|null $status
     * @property Carbon|null $deleted_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $status_text attribute
     * @property-read mixed[] $translations attribute
     * @property _IH_InstallmentPlanOption_C|InstallmentPlanOption[] $features
     * @property-read int $features_count
     * @method HasMany|_IH_InstallmentPlanOption_QB features()
     * @property _IH_InstallmentPlanPaymentStep_C|InstallmentPlanPaymentStep[] $paymentSteps
     * @property-read int $payment_steps_count
     * @method HasMany|_IH_InstallmentPlanPaymentStep_QB paymentSteps()
     * @property PlanSpecificItem $plan_specific_item
     * @method HasOne|_IH_PlanSpecificItem_QB plan_specific_item()
     * @method static _IH_InstallmentPlan_QB onWriteConnection()
     * @method _IH_InstallmentPlan_QB newQuery()
     * @method static _IH_InstallmentPlan_QB on(null|string $connection = null)
     * @method static _IH_InstallmentPlan_QB query()
     * @method static _IH_InstallmentPlan_QB with(array|string $relations)
     * @method _IH_InstallmentPlan_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstallmentPlan_C|InstallmentPlan[] all()
     * @foreignLinks id,\Modules\Installment\Entities\InstallmentPlanOption,installment_plan_id|id,\Modules\Installment\Entities\InstallmentPlanPaymentStep,installment_plan_id|id,\Modules\Installment\Entities\PlanSpecificItem,installment_plan_id
     * @mixin _IH_InstallmentPlan_QB
     */
    class InstallmentPlan extends Model {}
    
    /**
     * @property int $id
     * @property int $installment_plan_id
     * @property string $title
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_InstallmentPlanOption_QB onWriteConnection()
     * @method _IH_InstallmentPlanOption_QB newQuery()
     * @method static _IH_InstallmentPlanOption_QB on(null|string $connection = null)
     * @method static _IH_InstallmentPlanOption_QB query()
     * @method static _IH_InstallmentPlanOption_QB with(array|string $relations)
     * @method _IH_InstallmentPlanOption_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstallmentPlanOption_C|InstallmentPlanOption[] all()
     * @ownLinks installment_plan_id,\Modules\Installment\Entities\InstallmentPlan,id
     * @mixin _IH_InstallmentPlanOption_QB
     */
    class InstallmentPlanOption extends Model {}
    
    /**
     * @property int $id
     * @property int|null $installment_plan_id
     * @property string|null $payment_title
     * @property int|null $payment_deadline
     * @property float|null $payment_amount
     * @property string|null $amount_type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_InstallmentPlanPaymentStep_QB onWriteConnection()
     * @method _IH_InstallmentPlanPaymentStep_QB newQuery()
     * @method static _IH_InstallmentPlanPaymentStep_QB on(null|string $connection = null)
     * @method static _IH_InstallmentPlanPaymentStep_QB query()
     * @method static _IH_InstallmentPlanPaymentStep_QB with(array|string $relations)
     * @method _IH_InstallmentPlanPaymentStep_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstallmentPlanPaymentStep_C|InstallmentPlanPaymentStep[] all()
     * @ownLinks installment_plan_id,\Modules\Installment\Entities\InstallmentPlan,id
     * @mixin _IH_InstallmentPlanPaymentStep_QB
     */
    class InstallmentPlanPaymentStep extends Model {}
    
    /**
     * @property int $id
     * @property int $installment_purchase_id
     * @property string $type
     * @property int|null $step_id
     * @property float $amount
     * @property string|null $amount_type
     * @property float|null $percentage
     * @property Carbon|null $due_date
     * @property Carbon|null $payment_date
     * @property bool $is_overdue
     * @property string|null $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property InstallmentPurchaseRequest $installmentPurchaseRequest
     * @method BelongsTo|_IH_InstallmentPurchaseRequest_QB installmentPurchaseRequest()
     * @property InstallmentPlanPaymentStep|null $step
     * @method BelongsTo|_IH_InstallmentPlanPaymentStep_QB step()
     * @method static _IH_InstallmentPurchasePayment_QB onWriteConnection()
     * @method _IH_InstallmentPurchasePayment_QB newQuery()
     * @method static _IH_InstallmentPurchasePayment_QB on(null|string $connection = null)
     * @method static _IH_InstallmentPurchasePayment_QB query()
     * @method static _IH_InstallmentPurchasePayment_QB with(array|string $relations)
     * @method _IH_InstallmentPurchasePayment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstallmentPurchasePayment_C|InstallmentPurchasePayment[] all()
     * @mixin _IH_InstallmentPurchasePayment_QB
     */
    class InstallmentPurchasePayment extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $plan_id
     * @property int $topic_id
     * @property string|null $tracking
     * @property string|null $cart_data
     * @property int $total_installment
     * @property int $paid_installment
     * @property int $remaining_installment
     * @property float $paid_amount
     * @property array|null $checkout_data
     * @property float $remaining_amount
     * @property float $total_amount
     * @property Carbon|null $purchase_date
     * @property Carbon|null $next_payment_date
     * @property string $payment_status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_InstallmentVerificationAttachment_C|InstallmentVerificationAttachment[] $installmentAttachment
     * @property-read int $installment_attachment_count
     * @method HasMany|_IH_InstallmentVerificationAttachment_QB installmentAttachment()
     * @property _IH_InstallmentPurchasePayment_C|InstallmentPurchasePayment[] $installmentPayments
     * @property-read int $installment_payments_count
     * @method HasMany|_IH_InstallmentPurchasePayment_QB installmentPayments()
     * @property InstallmentCart $installment_cart
     * @method BelongsTo|_IH_InstallmentCart_QB installment_cart()
     * @property _IH_InstallmentPurchasePayment_C|InstallmentPurchasePayment[] $overdueInstallment
     * @property-read int $overdue_installment_count
     * @method HasMany|_IH_InstallmentPurchasePayment_QB overdueInstallment()
     * @property InstallmentPlan $plan
     * @method BelongsTo|_IH_InstallmentPlan_QB plan()
     * @property Course $topic
     * @method BelongsTo|_IH_Course_QB topic()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_InstallmentPurchaseRequest_QB onWriteConnection()
     * @method _IH_InstallmentPurchaseRequest_QB newQuery()
     * @method static _IH_InstallmentPurchaseRequest_QB on(null|string $connection = null)
     * @method static _IH_InstallmentPurchaseRequest_QB query()
     * @method static _IH_InstallmentPurchaseRequest_QB with(array|string $relations)
     * @method _IH_InstallmentPurchaseRequest_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstallmentPurchaseRequest_C|InstallmentPurchaseRequest[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_InstallmentPurchaseRequest_QB
     */
    class InstallmentPurchaseRequest extends Model {}
    
    /**
     * @property int $id
     * @property int $installment_purchase_id
     * @property string|null $title
     * @property string|null $file
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_InstallmentVerificationAttachment_QB onWriteConnection()
     * @method _IH_InstallmentVerificationAttachment_QB newQuery()
     * @method static _IH_InstallmentVerificationAttachment_QB on(null|string $connection = null)
     * @method static _IH_InstallmentVerificationAttachment_QB query()
     * @method static _IH_InstallmentVerificationAttachment_QB with(array|string $relations)
     * @method _IH_InstallmentVerificationAttachment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InstallmentVerificationAttachment_C|InstallmentVerificationAttachment[] all()
     * @mixin _IH_InstallmentVerificationAttachment_QB
     */
    class InstallmentVerificationAttachment extends Model {}
    
    /**
     * @property int $id
     * @property int|null $installment_plan_id
     * @property string|null $target_type
     * @property string|null $target
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_PlanSpecificItemDetails_C|PlanSpecificItemDetails[] $plan_specific_item_details
     * @property-read int $plan_specific_item_details_count
     * @method HasMany|_IH_PlanSpecificItemDetails_QB plan_specific_item_details()
     * @property _IH_PlanSpecificItemDetails_C|PlanSpecificItemDetails[] $plan_specific_item_details_relation
     * @property-read int $plan_specific_item_details_relation_count
     * @method HasMany|_IH_PlanSpecificItemDetails_QB plan_specific_item_details_relation()
     * @method static _IH_PlanSpecificItem_QB onWriteConnection()
     * @method _IH_PlanSpecificItem_QB newQuery()
     * @method static _IH_PlanSpecificItem_QB on(null|string $connection = null)
     * @method static _IH_PlanSpecificItem_QB query()
     * @method static _IH_PlanSpecificItem_QB with(array|string $relations)
     * @method _IH_PlanSpecificItem_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PlanSpecificItem_C|PlanSpecificItem[] all()
     * @ownLinks installment_plan_id,\Modules\Installment\Entities\InstallmentPlan,id
     * @foreignLinks id,\Modules\Installment\Entities\PlanSpecificItemDetails,plan_specific_item_id
     * @mixin _IH_PlanSpecificItem_QB
     */
    class PlanSpecificItem extends Model {}
    
    /**
     * @property int $id
     * @property int|null $plan_specific_item_id
     * @property int|null $item_id
     * @property string|null $type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PlanSpecificItemDetails_QB onWriteConnection()
     * @method _IH_PlanSpecificItemDetails_QB newQuery()
     * @method static _IH_PlanSpecificItemDetails_QB on(null|string $connection = null)
     * @method static _IH_PlanSpecificItemDetails_QB query()
     * @method static _IH_PlanSpecificItemDetails_QB with(array|string $relations)
     * @method _IH_PlanSpecificItemDetails_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PlanSpecificItemDetails_C|PlanSpecificItemDetails[] all()
     * @ownLinks plan_specific_item_id,\Modules\Installment\Entities\PlanSpecificItem,id
     * @mixin _IH_PlanSpecificItemDetails_QB
     */
    class PlanSpecificItemDetails extends Model {}
}