<?php //6ef106198789dc89facd2d1e151dafa9
/** @noinspection all */

namespace Modules\Invoice\Entities {

    use App\City;
    use App\Country;
    use App\State;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\_IH_City_QB;
    use LaravelIdea\Helper\App\_IH_Country_QB;
    use LaravelIdea\Helper\App\_IH_State_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\Invoice\Entities\_IH_InvoiceBilling_C;
    use LaravelIdea\Helper\Modules\Invoice\Entities\_IH_InvoiceBilling_QB;
    use LaravelIdea\Helper\Modules\Invoice\Entities\_IH_InvoiceCourse_C;
    use LaravelIdea\Helper\Modules\Invoice\Entities\_IH_InvoiceCourse_QB;
    use LaravelIdea\Helper\Modules\Invoice\Entities\_IH_InvoiceOfflinePayment_C;
    use LaravelIdea\Helper\Modules\Invoice\Entities\_IH_InvoiceOfflinePayment_QB;
    use LaravelIdea\Helper\Modules\Invoice\Entities\_IH_InvoiceSetting_C;
    use LaravelIdea\Helper\Modules\Invoice\Entities\_IH_InvoiceSetting_QB;
    use LaravelIdea\Helper\Modules\Invoice\Entities\_IH_Invoice_C;
    use LaravelIdea\Helper\Modules\Invoice\Entities\_IH_Invoice_QB;
    use LaravelIdea\Helper\Modules\Invoice\Entities\_IH_OrderCertificate_C;
    use LaravelIdea\Helper\Modules\Invoice\Entities\_IH_OrderCertificate_QB;
    use LaravelIdea\Helper\Modules\Invoice\Entities\_IH_PrintedCertificate_C;
    use LaravelIdea\Helper\Modules\Invoice\Entities\_IH_PrintedCertificate_QB;
    use LaravelIdea\Helper\Modules\Payment\Entities\_IH_Checkout_QB;
    use Modules\CourseSetting\Entities\Course;
    use Modules\Payment\Entities\Checkout;
    
    /**
     * @property int $id
     * @property string|null $tracking
     * @property string|null $invoice_number
     * @property int $user_id
     * @property int|null $checkout_id
     * @property int|null $billing_detail_id
     * @property int|null $package_id
     * @property int|null $coupon_id
     * @property float $discount
     * @property float $purchase_price
     * @property float $price
     * @property string $status
     * @property string|null $payment_method
     * @property int|null $payment_type
     * @property string|null $response
     * @property int|null $created_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property InvoiceBilling|null $billing
     * @method BelongsTo|_IH_InvoiceBilling_QB billing()
     * @property Checkout|null $checkout
     * @method BelongsTo|_IH_Checkout_QB checkout()
     * @property _IH_InvoiceCourse_C|InvoiceCourse[] $courses
     * @property-read int $courses_count
     * @method HasMany|_IH_InvoiceCourse_QB courses()
     * @property InvoiceOfflinePayment $offlinePayment
     * @method HasOne|_IH_InvoiceOfflinePayment_QB offlinePayment()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Invoice_QB onWriteConnection()
     * @method _IH_Invoice_QB newQuery()
     * @method static _IH_Invoice_QB on(null|string $connection = null)
     * @method static _IH_Invoice_QB query()
     * @method static _IH_Invoice_QB with(array|string $relations)
     * @method _IH_Invoice_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Invoice_C|Invoice[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|checkout_id,\Modules\Payment\Entities\Checkout,id|billing_detail_id,\App\BillingDetails,id|coupon_id,\Modules\Coupons\Entities\Coupon,id
     * @foreignLinks id,\Modules\Invoice\Entities\InvoiceOfflinePayment,invoice_id|id,\Modules\Payment\Entities\Checkout,invoice_id|id,\Modules\Invoice\Entities\InvoiceCourse,invoice_id
     * @mixin _IH_Invoice_QB
     */
    class Invoice extends Model {}
    
    /**
     * @property int $id
     * @property string $tracking_id
     * @property int $user_id
     * @property string|null $first_name
     * @property string|null $last_name
     * @property string|null $company_name
     * @property string|null $country
     * @property string|null $address1
     * @property string|null $address2
     * @property string|null $city
     * @property string|null $zip_code
     * @property string|null $phone
     * @property string|null $email
     * @property string|null $details
     * @property string|null $payment_method
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property City|null $cityDetails
     * @method BelongsTo|_IH_City_QB cityDetails()
     * @method BelongsTo|_IH_Country_QB country()
     * @property Country|null $countryDetails
     * @method BelongsTo|_IH_Country_QB countryDetails()
     * @property State $stateDetails
     * @method BelongsTo|_IH_State_QB stateDetails()
     * @method static _IH_InvoiceBilling_QB onWriteConnection()
     * @method _IH_InvoiceBilling_QB newQuery()
     * @method static _IH_InvoiceBilling_QB on(null|string $connection = null)
     * @method static _IH_InvoiceBilling_QB query()
     * @method static _IH_InvoiceBilling_QB with(array|string $relations)
     * @method _IH_InvoiceBilling_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InvoiceBilling_C|InvoiceBilling[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_InvoiceBilling_QB
     */
    class InvoiceBilling extends Model {}
    
    /**
     * @property int $id
     * @property int|null $invoice_id
     * @property string|null $tracking
     * @property int|null $course_id
     * @property int|null $instructor_id
     * @property int|null $user_id
     * @property float|null $price
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @method static _IH_InvoiceCourse_QB onWriteConnection()
     * @method _IH_InvoiceCourse_QB newQuery()
     * @method static _IH_InvoiceCourse_QB on(null|string $connection = null)
     * @method static _IH_InvoiceCourse_QB query()
     * @method static _IH_InvoiceCourse_QB with(array|string $relations)
     * @method _IH_InvoiceCourse_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InvoiceCourse_C|InvoiceCourse[] all()
     * @ownLinks invoice_id,\Modules\Invoice\Entities\Invoice,id|course_id,\Modules\CourseSetting\Entities\Course,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_InvoiceCourse_QB
     */
    class InvoiceCourse extends Model {}
    
    /**
     * @property int $id
     * @property int|null $invoice_id
     * @property int $checkout_id
     * @property int $user_id
     * @property string|null $bank_name
     * @property string|null $account_holder
     * @property string|null $branch_name
     * @property string|null $amount
     * @property string|null $account_number
     * @property string|null $image
     * @property int $status
     * @property int|null $accept_or_reject
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Invoice|null $invoice
     * @method BelongsTo|_IH_Invoice_QB invoice()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_InvoiceOfflinePayment_QB onWriteConnection()
     * @method _IH_InvoiceOfflinePayment_QB newQuery()
     * @method static _IH_InvoiceOfflinePayment_QB on(null|string $connection = null)
     * @method static _IH_InvoiceOfflinePayment_QB query()
     * @method static _IH_InvoiceOfflinePayment_QB with(array|string $relations)
     * @method _IH_InvoiceOfflinePayment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InvoiceOfflinePayment_C|InvoiceOfflinePayment[] all()
     * @ownLinks invoice_id,\Modules\Invoice\Entities\Invoice,id|checkout_id,\Modules\Payment\Entities\Checkout,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_InvoiceOfflinePayment_QB
     */
    class InvoiceOfflinePayment extends Model {}
    
    /**
     * @property int $id
     * @property string|null $footer_text
     * @property string|null $prefix
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_InvoiceSetting_QB onWriteConnection()
     * @method _IH_InvoiceSetting_QB newQuery()
     * @method static _IH_InvoiceSetting_QB on(null|string $connection = null)
     * @method static _IH_InvoiceSetting_QB query()
     * @method static _IH_InvoiceSetting_QB with(array|string $relations)
     * @method _IH_InvoiceSetting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_InvoiceSetting_C|InvoiceSetting[] all()
     * @mixin _IH_InvoiceSetting_QB
     */
    class InvoiceSetting extends Model {}
    
    /**
     * @property int $id
     * @property string|null $tracking
     * @property int|null $checkout_id
     * @property int|null $certificate_id
     * @property float|null $price
     * @property int|null $course_id
     * @property int|null $user_id
     * @property string|null $status
     * @property int|null $accepted
     * @property int $payment_status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_OrderCertificate_QB onWriteConnection()
     * @method _IH_OrderCertificate_QB newQuery()
     * @method static _IH_OrderCertificate_QB on(null|string $connection = null)
     * @method static _IH_OrderCertificate_QB query()
     * @method static _IH_OrderCertificate_QB with(array|string $relations)
     * @method _IH_OrderCertificate_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_OrderCertificate_C|OrderCertificate[] all()
     * @ownLinks checkout_id,\Modules\Payment\Entities\Checkout,id|certificate_id,\Modules\Certificate\Entities\Certificate,id|course_id,\Modules\CourseSetting\Entities\Course,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @foreignLinks id,\Modules\Payment\Entities\Checkout,order_certificate_id
     * @mixin _IH_OrderCertificate_QB
     */
    class OrderCertificate extends Model {}
    
    /**
     * @property int $id
     * @property string|null $title
     * @property float|null $price
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_PrintedCertificate_QB onWriteConnection()
     * @method _IH_PrintedCertificate_QB newQuery()
     * @method static _IH_PrintedCertificate_QB on(null|string $connection = null)
     * @method static _IH_PrintedCertificate_QB query()
     * @method static _IH_PrintedCertificate_QB with(array|string $relations)
     * @method _IH_PrintedCertificate_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PrintedCertificate_C|PrintedCertificate[] all()
     * @mixin _IH_PrintedCertificate_QB
     */
    class PrintedCertificate extends Model {}
}