<?php //58ca8492518c7dbe7d4e4478be9f50e7
/** @noinspection all */

namespace Modules\Forum\Entities {

    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Category_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\Forum\Entities\_IH_ForumLike_C;
    use LaravelIdea\Helper\Modules\Forum\Entities\_IH_ForumLike_QB;
    use LaravelIdea\Helper\Modules\Forum\Entities\_IH_ForumReplyLike_C;
    use LaravelIdea\Helper\Modules\Forum\Entities\_IH_ForumReplyLike_QB;
    use LaravelIdea\Helper\Modules\Forum\Entities\_IH_ForumReply_C;
    use LaravelIdea\Helper\Modules\Forum\Entities\_IH_ForumReply_QB;
    use LaravelIdea\Helper\Modules\Forum\Entities\_IH_ForumView_C;
    use LaravelIdea\Helper\Modules\Forum\Entities\_IH_ForumView_QB;
    use LaravelIdea\Helper\Modules\Forum\Entities\_IH_Forum_C;
    use LaravelIdea\Helper\Modules\Forum\Entities\_IH_Forum_QB;
    use LaravelIdea\Helper\Modules\Org\Entities\_IH_OrgForumBranch_C;
    use LaravelIdea\Helper\Modules\Org\Entities\_IH_OrgForumBranch_QB;
    use LaravelIdea\Helper\Modules\Org\Entities\_IH_OrgForumPosition_C;
    use LaravelIdea\Helper\Modules\Org\Entities\_IH_OrgForumPosition_QB;
    use LaravelIdea\Helper\Modules\OrgSubscription\Entities\_IH_OrgCourseSubscription_QB;
    use Modules\CourseSetting\Entities\Category;
    use Modules\CourseSetting\Entities\Course;
    use Modules\Org\Entities\OrgForumBranch;
    use Modules\Org\Entities\OrgForumPosition;
    use Modules\OrgSubscription\Entities\OrgCourseSubscription;
    
    /**
     * @property int $id
     * @property string $title
     * @property string $description
     * @property int $created_by
     * @property int|null $course_id
     * @property int|null $category_id
     * @property int|null $lesson_id
     * @property int|null $group_id
     * @property int|null $homework_id
     * @property int|null $privacy
     * @property int|null $status
     * @property int|null $view
     * @property int|null $reply
     * @property int|null $is_closed
     * @property Carbon|null $last_activity
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $topic_type
     * @property Carbon|null $deleted_at
     * @property int $deleted_by
     * @property int $parent_id
     * @property int $path_id
     * @property string|null $filter
     * @property int $total_replies
     * @property int $total_views
     * @property int $total_likes
     * @property int $total_threads
     * @property Carbon|null $approved_at
     * @property int $pin
     * @property int $lock
     * @property-read bool $is_login_user_viewable attribute
     * @property _IH_ForumReply_C|ForumReply[] $all_replies
     * @property-read int $all_replies_count
     * @method HasMany|_IH_ForumReply_QB all_replies()
     * @property Category|null $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property User $deletedUser
     * @method BelongsTo|_IH_User_QB deletedUser()
     * @property ForumLike $forumLike
     * @method HasOne|_IH_ForumLike_QB forumLike()
     * @property _IH_OrgForumBranch_C|OrgForumBranch[] $forumOrgBranches
     * @property-read int $forum_org_branches_count
     * @method HasMany|_IH_OrgForumBranch_QB forumOrgBranches()
     * @property _IH_OrgForumPosition_C|OrgForumPosition[] $forumOrgPositions
     * @property-read int $forum_org_positions_count
     * @method HasMany|_IH_OrgForumPosition_QB forumOrgPositions()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_ForumLike_C|ForumLike[] $likes
     * @property-read int $likes_count
     * @method HasMany|_IH_ForumLike_QB likes()
     * @property OrgCourseSubscription $path
     * @method BelongsTo|_IH_OrgCourseSubscription_QB path()
     * @property _IH_ForumReply_C|ForumReply[] $replies
     * @property-read int $replies_count
     * @method HasMany|_IH_ForumReply_QB replies()
     * @property _IH_Forum_C|Forum[] $threads
     * @property-read int $threads_count
     * @method HasMany|_IH_Forum_QB threads()
     * @property Forum $topic
     * @method BelongsTo|_IH_Forum_QB topic()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @property ForumView $view_info
     * @method HasOne|_IH_ForumView_QB view_info()
     * @property _IH_ForumView_C|ForumView[] $views
     * @property-read int $views_count
     * @method HasMany|_IH_ForumView_QB views()
     * @method static _IH_Forum_QB onWriteConnection()
     * @method _IH_Forum_QB newQuery()
     * @method static _IH_Forum_QB on(null|string $connection = null)
     * @method static _IH_Forum_QB query()
     * @method static _IH_Forum_QB with(array|string $relations)
     * @method _IH_Forum_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Forum_C|Forum[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id|category_id,\Modules\CourseSetting\Entities\Category,id|lesson_id,\Modules\CourseSetting\Entities\Lesson,id|group_id,\Modules\Group\Entities\Group,id
     * @foreignLinks id,\Modules\Forum\Entities\ForumReply,forum_id|id,\Modules\Forum\Entities\ForumView,forum_id|id,\Modules\Org\Entities\OrgForumBranch,forum_id|id,\Modules\Org\Entities\OrgForumPosition,forum_id|id,\Modules\Forum\Entities\ForumLike,forum_id
     * @mixin _IH_Forum_QB
     */
    class Forum extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $forum_id
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ForumLike_QB onWriteConnection()
     * @method _IH_ForumLike_QB newQuery()
     * @method static _IH_ForumLike_QB on(null|string $connection = null)
     * @method static _IH_ForumLike_QB query()
     * @method static _IH_ForumLike_QB with(array|string $relations)
     * @method _IH_ForumLike_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ForumLike_C|ForumLike[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|forum_id,\Modules\Forum\Entities\Forum,id
     * @mixin _IH_ForumLike_QB
     */
    class ForumLike extends Model {}
    
    /**
     * @property int $id
     * @property int|null $forum_id
     * @property int $user_id
     * @property string $reply
     * @property int|null $parent_id
     * @property int|null $status
     * @property int|null $points
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $total_likes
     * @property int $pin
     * @property Forum|null $forum
     * @method BelongsTo|_IH_Forum_QB forum()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_ForumReply_C|ForumReply[] $repliesofReply
     * @property-read int $repliesof_reply_count
     * @method HasMany|_IH_ForumReply_QB repliesofReply()
     * @property ForumReplyLike $replyLike
     * @method HasOne|_IH_ForumReplyLike_QB replyLike()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_ForumReply_QB onWriteConnection()
     * @method _IH_ForumReply_QB newQuery()
     * @method static _IH_ForumReply_QB on(null|string $connection = null)
     * @method static _IH_ForumReply_QB query()
     * @method static _IH_ForumReply_QB with(array|string $relations)
     * @method _IH_ForumReply_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ForumReply_C|ForumReply[] all()
     * @ownLinks forum_id,\Modules\Forum\Entities\Forum,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_ForumReply_QB
     */
    class ForumReply extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $reply_id
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ForumReplyLike_QB onWriteConnection()
     * @method _IH_ForumReplyLike_QB newQuery()
     * @method static _IH_ForumReplyLike_QB on(null|string $connection = null)
     * @method static _IH_ForumReplyLike_QB query()
     * @method static _IH_ForumReplyLike_QB with(array|string $relations)
     * @method _IH_ForumReplyLike_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ForumReplyLike_C|ForumReplyLike[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_ForumReplyLike_QB
     */
    class ForumReplyLike extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $forum_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $lms_id
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_ForumView_QB onWriteConnection()
     * @method _IH_ForumView_QB newQuery()
     * @method static _IH_ForumView_QB on(null|string $connection = null)
     * @method static _IH_ForumView_QB query()
     * @method static _IH_ForumView_QB with(array|string $relations)
     * @method _IH_ForumView_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ForumView_C|ForumView[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|forum_id,\Modules\Forum\Entities\Forum,id
     * @mixin _IH_ForumView_QB
     */
    class ForumView extends Model {}
}