<?php //6448d598b0ecbf680e6108e1d917e660
/** @noinspection all */

namespace Modules\Setting\Model {

    use App\Models\LmsInstitute;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\Modules\Localization\Entities\_IH_Language_QB;
    use LaravelIdea\Helper\Modules\Setting\Model\_IH_BusinessSetting_C;
    use LaravelIdea\Helper\Modules\Setting\Model\_IH_BusinessSetting_QB;
    use LaravelIdea\Helper\Modules\Setting\Model\_IH_Currency_C;
    use LaravelIdea\Helper\Modules\Setting\Model\_IH_Currency_QB;
    use LaravelIdea\Helper\Modules\Setting\Model\_IH_DateFormat_C;
    use LaravelIdea\Helper\Modules\Setting\Model\_IH_DateFormat_QB;
    use LaravelIdea\Helper\Modules\Setting\Model\_IH_GeneralSetting_C;
    use LaravelIdea\Helper\Modules\Setting\Model\_IH_GeneralSetting_QB;
    use LaravelIdea\Helper\Modules\Setting\Model\_IH_SmsGateway_C;
    use LaravelIdea\Helper\Modules\Setting\Model\_IH_SmsGateway_QB;
    use LaravelIdea\Helper\Modules\Setting\Model\_IH_TimeZone_C;
    use LaravelIdea\Helper\Modules\Setting\Model\_IH_TimeZone_QB;
    use Modules\Localization\Entities\Language;
    
    /**
     * @property int $id
     * @property string $type
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_BusinessSetting_QB onWriteConnection()
     * @method _IH_BusinessSetting_QB newQuery()
     * @method static _IH_BusinessSetting_QB on(null|string $connection = null)
     * @method static _IH_BusinessSetting_QB query()
     * @method static _IH_BusinessSetting_QB with(array|string $relations)
     * @method _IH_BusinessSetting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_BusinessSetting_C|BusinessSetting[] all()
     * @mixin _IH_BusinessSetting_QB
     */
    class BusinessSetting extends Model {}
    
    /**
     * @property int $id
     * @property string|null $name
     * @property string|null $code
     * @property string|null $symbol
     * @property float $conversion_rate
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_Currency_QB onWriteConnection()
     * @method _IH_Currency_QB newQuery()
     * @method static _IH_Currency_QB on(null|string $connection = null)
     * @method static _IH_Currency_QB query()
     * @method static _IH_Currency_QB with(array|string $relations)
     * @method _IH_Currency_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Currency_C|Currency[] all()
     * @foreignLinks id,\PragmaRX\Google2FALaravel\Tests\Support\User,currency_id
     * @mixin _IH_Currency_QB
     */
    class Currency extends Model {}
    
    /**
     * @property int $id
     * @property string|null $format
     * @property string|null $normal_view
     * @property int $status
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_DateFormat_QB onWriteConnection()
     * @method _IH_DateFormat_QB newQuery()
     * @method static _IH_DateFormat_QB on(null|string $connection = null)
     * @method static _IH_DateFormat_QB query()
     * @method static _IH_DateFormat_QB with(array|string $relations)
     * @method _IH_DateFormat_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DateFormat_C|DateFormat[] all()
     * @mixin _IH_DateFormat_QB
     */
    class DateFormat extends Model {}
    
    /**
     * @property int $id
     * @property string $key
     * @property string|null $value
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $last_updated_date
     * @property string|null $system_version
     * @property int $show_review_for_bundle_subscription
     * @property float|null $appointment_commission
     * @property Currency $currency
     * @method BelongsTo|_IH_Currency_QB currency()
     * @property DateFormat $date_format
     * @method BelongsTo|_IH_DateFormat_QB date_format()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property Language $language
     * @method BelongsTo|_IH_Language_QB language()
     * @property TimeZone $timezone
     * @method BelongsTo|_IH_TimeZone_QB timezone()
     * @method static _IH_GeneralSetting_QB onWriteConnection()
     * @method _IH_GeneralSetting_QB newQuery()
     * @method static _IH_GeneralSetting_QB on(null|string $connection = null)
     * @method static _IH_GeneralSetting_QB query()
     * @method static _IH_GeneralSetting_QB with(array|string $relations)
     * @method _IH_GeneralSetting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_GeneralSetting_C|GeneralSetting[] all()
     * @mixin _IH_GeneralSetting_QB
     */
    class GeneralSetting extends Model {}
    
    /**
     * @property int $id
     * @property string|null $gateway_name
     * @property string|null $gateway_url
     * @property string|null $request_method
     * @property string|null $set_auth
     * @property string|null $send_to_parameter_name
     * @property string|null $message_to_parameter_name
     * @property string|null $gateway_logo
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $add_plus
     * @method static _IH_SmsGateway_QB onWriteConnection()
     * @method _IH_SmsGateway_QB newQuery()
     * @method static _IH_SmsGateway_QB on(null|string $connection = null)
     * @method static _IH_SmsGateway_QB query()
     * @method static _IH_SmsGateway_QB with(array|string $relations)
     * @method _IH_SmsGateway_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SmsGateway_C|SmsGateway[] all()
     * @foreignLinks id,\Modules\Setting\Entities\SmsGatewayParameter,gateway_id
     * @mixin _IH_SmsGateway_QB
     */
    class SmsGateway extends Model {}
    
    /**
     * @property int $id
     * @property string|null $code
     * @property string|null $time_zone
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_TimeZone_QB onWriteConnection()
     * @method _IH_TimeZone_QB newQuery()
     * @method static _IH_TimeZone_QB on(null|string $connection = null)
     * @method static _IH_TimeZone_QB query()
     * @method static _IH_TimeZone_QB with(array|string $relations)
     * @method _IH_TimeZone_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TimeZone_C|TimeZone[] all()
     * @mixin _IH_TimeZone_QB
     */
    class TimeZone extends Model {}
}