<?php //13214b3ffcc237716e0d297100615637
/** @noinspection all */

namespace Modules\UpcomingCourse\Entities {

    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use LaravelIdea\Helper\Modules\UpcomingCourse\Entities\_IH_UpcomingCourseBookingPayment_C;
    use LaravelIdea\Helper\Modules\UpcomingCourse\Entities\_IH_UpcomingCourseBookingPayment_QB;
    use LaravelIdea\Helper\Modules\UpcomingCourse\Entities\_IH_UpcomingCourseBooking_C;
    use LaravelIdea\Helper\Modules\UpcomingCourse\Entities\_IH_UpcomingCourseBooking_QB;
    use LaravelIdea\Helper\Modules\UpcomingCourse\Entities\_IH_UpcomingCourseFollower_C;
    use LaravelIdea\Helper\Modules\UpcomingCourse\Entities\_IH_UpcomingCourseFollower_QB;
    use Modules\CourseSetting\Entities\Course;
    
    /**
     * @property int $id
     * @property int $course_id
     * @property int $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property _IH_UpcomingCourseBookingPayment_C|UpcomingCourseBookingPayment[] $payments
     * @property-read int $payments_count
     * @method HasMany|_IH_UpcomingCourseBookingPayment_QB payments()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_UpcomingCourseBooking_QB onWriteConnection()
     * @method _IH_UpcomingCourseBooking_QB newQuery()
     * @method static _IH_UpcomingCourseBooking_QB on(null|string $connection = null)
     * @method static _IH_UpcomingCourseBooking_QB query()
     * @method static _IH_UpcomingCourseBooking_QB with(array|string $relations)
     * @method _IH_UpcomingCourseBooking_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UpcomingCourseBooking_C|UpcomingCourseBooking[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_UpcomingCourseBooking_QB
     */
    class UpcomingCourseBooking extends Model {}
    
    /**
     * @property int $id
     * @property int $booking_id
     * @property int $user_id
     * @property float $amount
     * @property string|null $payment_method
     * @property string|null $transaction_id
     * @property string|null $response
     * @property bool $status
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_UpcomingCourseBookingPayment_QB onWriteConnection()
     * @method _IH_UpcomingCourseBookingPayment_QB newQuery()
     * @method static _IH_UpcomingCourseBookingPayment_QB on(null|string $connection = null)
     * @method static _IH_UpcomingCourseBookingPayment_QB query()
     * @method static _IH_UpcomingCourseBookingPayment_QB with(array|string $relations)
     * @method _IH_UpcomingCourseBookingPayment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UpcomingCourseBookingPayment_C|UpcomingCourseBookingPayment[] all()
     * @ownLinks booking_id,\Modules\Appointment\Entities\Booking,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_UpcomingCourseBookingPayment_QB
     */
    class UpcomingCourseBookingPayment extends Model {}
    
    /**
     * @property int $id
     * @property int $course_id
     * @property int $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Course $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_UpcomingCourseFollower_QB onWriteConnection()
     * @method _IH_UpcomingCourseFollower_QB newQuery()
     * @method static _IH_UpcomingCourseFollower_QB on(null|string $connection = null)
     * @method static _IH_UpcomingCourseFollower_QB query()
     * @method static _IH_UpcomingCourseFollower_QB with(array|string $relations)
     * @method _IH_UpcomingCourseFollower_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UpcomingCourseFollower_C|UpcomingCourseFollower[] all()
     * @ownLinks course_id,\Modules\CourseSetting\Entities\Course,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_UpcomingCourseFollower_QB
     */
    class UpcomingCourseFollower extends Model {}
}