<?php //1baaf44aee13e2183a31e8735ed38931
/** @noinspection all */

namespace Modules\Affiliate\Entities {

    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Affiliate\Entities\_IH_AffiliateConfiguration_C;
    use LaravelIdea\Helper\Modules\Affiliate\Entities\_IH_AffiliateConfiguration_QB;
    use LaravelIdea\Helper\Modules\Affiliate\Entities\_IH_AffiliateLinkVisitTrackUser_C;
    use LaravelIdea\Helper\Modules\Affiliate\Entities\_IH_AffiliateLinkVisitTrackUser_QB;
    use LaravelIdea\Helper\Modules\Affiliate\Entities\_IH_AffiliateLink_C;
    use LaravelIdea\Helper\Modules\Affiliate\Entities\_IH_AffiliateLink_QB;
    use LaravelIdea\Helper\Modules\Affiliate\Entities\_IH_AffiliateReferralPayment_C;
    use LaravelIdea\Helper\Modules\Affiliate\Entities\_IH_AffiliateReferralPayment_QB;
    use LaravelIdea\Helper\Modules\Affiliate\Entities\_IH_AffiliateUserWallet_C;
    use LaravelIdea\Helper\Modules\Affiliate\Entities\_IH_AffiliateUserWallet_QB;
    use LaravelIdea\Helper\Modules\Affiliate\Entities\_IH_AffiliateWithdraw_C;
    use LaravelIdea\Helper\Modules\Affiliate\Entities\_IH_AffiliateWithdraw_QB;
    use LaravelIdea\Helper\Modules\Affiliate\Entities\_IH_ReferralUser_C;
    use LaravelIdea\Helper\Modules\Affiliate\Entities\_IH_ReferralUser_QB;
    use LaravelIdea\Helper\Modules\CourseSetting\Entities\_IH_Course_QB;
    use Modules\CourseSetting\Entities\Course;
    
    /**
     * @property int $id
     * @property string $key
     * @property string|null $value
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_AffiliateConfiguration_QB onWriteConnection()
     * @method _IH_AffiliateConfiguration_QB newQuery()
     * @method static _IH_AffiliateConfiguration_QB on(null|string $connection = null)
     * @method static _IH_AffiliateConfiguration_QB query()
     * @method static _IH_AffiliateConfiguration_QB with(array|string $relations)
     * @method _IH_AffiliateConfiguration_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AffiliateConfiguration_C|AffiliateConfiguration[] all()
     * @mixin _IH_AffiliateConfiguration_QB
     */
    class AffiliateConfiguration extends Model {}
    
    /**
     * @property int $id
     * @property string $affiliate_link
     * @property int $owner_id
     * @property int $visits
     * @property int $registered
     * @property int $purchased
     * @property int $commissions
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User $owner
     * @method BelongsTo|_IH_User_QB owner()
     * @property _IH_AffiliateReferralPayment_C|AffiliateReferralPayment[] $payment
     * @property-read int $payment_count
     * @method HasMany|_IH_AffiliateReferralPayment_QB payment()
     * @property _IH_ReferralUser_C|ReferralUser[] $registerUser
     * @property-read int $register_user_count
     * @method HasMany|_IH_ReferralUser_QB registerUser()
     * @method static _IH_AffiliateLink_QB onWriteConnection()
     * @method _IH_AffiliateLink_QB newQuery()
     * @method static _IH_AffiliateLink_QB on(null|string $connection = null)
     * @method static _IH_AffiliateLink_QB query()
     * @method static _IH_AffiliateLink_QB with(array|string $relations)
     * @method _IH_AffiliateLink_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AffiliateLink_C|AffiliateLink[] all()
     * @foreignLinks id,\Modules\Affiliate\Entities\AffiliateLinkVisitTrackUser,affiliate_link_id|id,\Modules\Affiliate\Entities\ReferralUser,affiliate_link_id|id,\Modules\Affiliate\Entities\AffiliateReferralPayment,affiliate_link_id
     * @mixin _IH_AffiliateLink_QB
     */
    class AffiliateLink extends Model {}
    
    /**
     * @property int $id
     * @property int $affiliate_link_id
     * @property string $ip
     * @property string $agent
     * @property Carbon $date
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_AffiliateLinkVisitTrackUser_QB onWriteConnection()
     * @method _IH_AffiliateLinkVisitTrackUser_QB newQuery()
     * @method static _IH_AffiliateLinkVisitTrackUser_QB on(null|string $connection = null)
     * @method static _IH_AffiliateLinkVisitTrackUser_QB query()
     * @method static _IH_AffiliateLinkVisitTrackUser_QB with(array|string $relations)
     * @method _IH_AffiliateLinkVisitTrackUser_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AffiliateLinkVisitTrackUser_C|AffiliateLinkVisitTrackUser[] all()
     * @ownLinks affiliate_link_id,\Modules\Affiliate\Entities\AffiliateLink,id
     * @mixin _IH_AffiliateLinkVisitTrackUser_QB
     */
    class AffiliateLinkVisitTrackUser extends Model {}
    
    /**
     * @property int $id
     * @property int $payment_to
     * @property float $amount
     * @property int $affiliate_link_id
     * @property int $payment_from
     * @property int|null $course_id
     * @property Carbon|null $date
     * @property bool $status
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Course|null $course
     * @method BelongsTo|_IH_Course_QB course()
     * @property User $incomeFrom
     * @method BelongsTo|_IH_User_QB incomeFrom()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_AffiliateReferralPayment_QB onWriteConnection()
     * @method _IH_AffiliateReferralPayment_QB newQuery()
     * @method static _IH_AffiliateReferralPayment_QB on(null|string $connection = null)
     * @method static _IH_AffiliateReferralPayment_QB query()
     * @method static _IH_AffiliateReferralPayment_QB with(array|string $relations)
     * @method _IH_AffiliateReferralPayment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AffiliateReferralPayment_C|AffiliateReferralPayment[] all()
     * @ownLinks affiliate_link_id,\Modules\Affiliate\Entities\AffiliateLink,id|course_id,\Modules\CourseSetting\Entities\Course,id
     * @mixin _IH_AffiliateReferralPayment_QB
     */
    class AffiliateReferralPayment extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property float $amount
     * @property string|null $paypal_account
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_AffiliateUserWallet_QB onWriteConnection()
     * @method _IH_AffiliateUserWallet_QB newQuery()
     * @method static _IH_AffiliateUserWallet_QB on(null|string $connection = null)
     * @method static _IH_AffiliateUserWallet_QB query()
     * @method static _IH_AffiliateUserWallet_QB with(array|string $relations)
     * @method _IH_AffiliateUserWallet_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AffiliateUserWallet_C|AffiliateUserWallet[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_AffiliateUserWallet_QB
     */
    class AffiliateUserWallet extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property float $withdraw_amount
     * @property int $payment_type
     * @property bool $status
     * @property Carbon $request_date
     * @property int|null $confirmed_by
     * @property Carbon|null $confirm_date
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User|null $confirmedUser
     * @method BelongsTo|_IH_User_QB confirmedUser()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_AffiliateWithdraw_QB onWriteConnection()
     * @method _IH_AffiliateWithdraw_QB newQuery()
     * @method static _IH_AffiliateWithdraw_QB on(null|string $connection = null)
     * @method static _IH_AffiliateWithdraw_QB query()
     * @method static _IH_AffiliateWithdraw_QB with(array|string $relations)
     * @method _IH_AffiliateWithdraw_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_AffiliateWithdraw_C|AffiliateWithdraw[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_AffiliateWithdraw_QB
     */
    class AffiliateWithdraw extends Model {}
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $affiliate_link_id
     * @property Carbon|null $validity_start_date
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property AffiliateLink $affiliateLink
     * @method BelongsTo|_IH_AffiliateLink_QB affiliateLink()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_ReferralUser_QB onWriteConnection()
     * @method _IH_ReferralUser_QB newQuery()
     * @method static _IH_ReferralUser_QB on(null|string $connection = null)
     * @method static _IH_ReferralUser_QB query()
     * @method static _IH_ReferralUser_QB with(array|string $relations)
     * @method _IH_ReferralUser_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ReferralUser_C|ReferralUser[] all()
     * @ownLinks affiliate_link_id,\Modules\Affiliate\Entities\AffiliateLink,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_ReferralUser_QB
     */
    class ReferralUser extends Model {}
}