<?php //0e81f9de093ec400e96421b58b93e65a
/** @noinspection all */

namespace Modules\HumanResource\Entities {

    use App\Models\LmsInstitute;
    use App\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_LmsInstitute_QB;
    use LaravelIdea\Helper\App\_IH_User_QB;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_ApplyLeave_C;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_ApplyLeave_QB;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_Attendance_C;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_Attendance_QB;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_Department_C;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_Department_QB;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_Event_C;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_Event_QB;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_Holiday_C;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_Holiday_QB;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_LeaveDefine_C;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_LeaveDefine_QB;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_LeaveType_C;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_LeaveType_QB;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_PayrollEarnDeduce_C;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_PayrollEarnDeduce_QB;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_Payroll_C;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_Payroll_QB;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_SmLeaveDeductionInfo_C;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_SmLeaveDeductionInfo_QB;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_StaffDocument_C;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_StaffDocument_QB;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_Staff_C;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_Staff_QB;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_ToDo_C;
    use LaravelIdea\Helper\Modules\HumanResource\Entities\_IH_ToDo_QB;
    use LaravelIdea\Helper\Modules\RolePermission\Entities\_IH_Role_QB;
    use Modules\RolePermission\Entities\Role;
    
    /**
     * @property int $id
     * @property int $user_id
     * @property int $leave_type_id
     * @property string $reason
     * @property string|null $attachment
     * @property Carbon $apply_date
     * @property Carbon $start_date
     * @property Carbon|null $end_date
     * @property bool $day
     * @property bool $makeup_leave
     * @property Carbon|null $makeup_date
     * @property bool $makeup_half
     * @property bool $leave_from
     * @property bool $leave_to
     * @property float $total_days
     * @property bool $status
     * @property int|null $approved_by
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property User|null $approveUser
     * @method BelongsTo|_IH_User_QB approveUser()
     * @property User|null $creator
     * @method BelongsTo|_IH_User_QB creator()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property LeaveType $leave_type
     * @method BelongsTo|_IH_LeaveType_QB leave_type()
     * @property User|null $updator
     * @method BelongsTo|_IH_User_QB updator()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_ApplyLeave_QB onWriteConnection()
     * @method _IH_ApplyLeave_QB newQuery()
     * @method static _IH_ApplyLeave_QB on(null|string $connection = null)
     * @method static _IH_ApplyLeave_QB query()
     * @method static _IH_ApplyLeave_QB with(array|string $relations)
     * @method _IH_ApplyLeave_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ApplyLeave_C|ApplyLeave[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|leave_type_id,\Modules\HumanResource\Entities\LeaveType,id
     * @mixin _IH_ApplyLeave_QB
     */
    class ApplyLeave extends Model {}
    
    /**
     * @property int $id
     * @property string $attendance
     * @property Carbon|null $date
     * @property string|null $day
     * @property string|null $month
     * @property int|null $year
     * @property string|null $note
     * @property int $user_id
     * @property int $role_id
     * @property int|null $course_id
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $entering_time
     * @property string|null $leaving_time
     * @property string|null $late_note
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Attendance_QB onWriteConnection()
     * @method _IH_Attendance_QB newQuery()
     * @method static _IH_Attendance_QB on(null|string $connection = null)
     * @method static _IH_Attendance_QB query()
     * @method static _IH_Attendance_QB with(array|string $relations)
     * @method _IH_Attendance_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Attendance_C|Attendance[] all()
     * @ownLinks created_by,\PragmaRX\Google2FALaravel\Tests\Support\User,id|updated_by,\PragmaRX\Google2FALaravel\Tests\Support\User,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|role_id,\Modules\RolePermission\Entities\Role,id|course_id,\Modules\CourseSetting\Entities\Course,id
     * @mixin _IH_Attendance_QB
     */
    class Attendance extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $details
     * @property string|null $user_id
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int $lms_id
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property Staff|null $staff
     * @method BelongsTo|_IH_Staff_QB staff()
     * @method static _IH_Department_QB onWriteConnection()
     * @method _IH_Department_QB newQuery()
     * @method static _IH_Department_QB on(null|string $connection = null)
     * @method static _IH_Department_QB query()
     * @method static _IH_Department_QB with(array|string $relations)
     * @method _IH_Department_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Department_C|Department[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_Department_QB
     */
    class Department extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property string $for_whom
     * @property string $location
     * @property string|null $description
     * @property Carbon|null $from_date
     * @property Carbon|null $to_date
     * @property string|null $image
     * @property bool $status
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_Event_QB onWriteConnection()
     * @method _IH_Event_QB newQuery()
     * @method static _IH_Event_QB on(null|string $connection = null)
     * @method static _IH_Event_QB query()
     * @method static _IH_Event_QB with(array|string $relations)
     * @method _IH_Event_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Event_C|Event[] all()
     * @foreignLinks id,\Modules\Calendar\Entities\Calendar,event_id
     * @mixin _IH_Event_QB
     */
    class Event extends Model {}
    
    /**
     * @property int $id
     * @property int $year
     * @property string|null $name
     * @property bool $type
     * @property string|null $date
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_Holiday_QB onWriteConnection()
     * @method _IH_Holiday_QB newQuery()
     * @method static _IH_Holiday_QB on(null|string $connection = null)
     * @method static _IH_Holiday_QB query()
     * @method static _IH_Holiday_QB with(array|string $relations)
     * @method _IH_Holiday_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Holiday_C|Holiday[] all()
     * @mixin _IH_Holiday_QB
     */
    class Holiday extends Model {}
    
    /**
     * @property int $id
     * @property int $role_id
     * @property int|null $user_id
     * @property int $leave_type_id
     * @property int $total_days
     * @property int $max_forward
     * @property bool $balance_forward
     * @property bool $adjusted
     * @property int|null $year
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property LeaveType $leave_type
     * @method BelongsTo|_IH_LeaveType_QB leave_type()
     * @property Role $role
     * @method BelongsTo|_IH_Role_QB role()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_LeaveDefine_QB onWriteConnection()
     * @method _IH_LeaveDefine_QB newQuery()
     * @method static _IH_LeaveDefine_QB on(null|string $connection = null)
     * @method static _IH_LeaveDefine_QB query()
     * @method static _IH_LeaveDefine_QB with(array|string $relations)
     * @method _IH_LeaveDefine_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_LeaveDefine_C|LeaveDefine[] all()
     * @ownLinks role_id,\Modules\RolePermission\Entities\Role,id|user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id|leave_type_id,\Modules\HumanResource\Entities\LeaveType,id
     * @mixin _IH_LeaveDefine_QB
     */
    class LeaveDefine extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property bool $status
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_LeaveType_QB onWriteConnection()
     * @method _IH_LeaveType_QB newQuery()
     * @method static _IH_LeaveType_QB on(null|string $connection = null)
     * @method static _IH_LeaveType_QB query()
     * @method static _IH_LeaveType_QB with(array|string $relations)
     * @method _IH_LeaveType_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_LeaveType_C|LeaveType[] all()
     * @foreignLinks id,\Modules\HumanResource\Entities\LeaveDefine,leave_type_id|id,\Modules\HumanResource\Entities\ApplyLeave,leave_type_id
     * @mixin _IH_LeaveType_QB
     */
    class LeaveType extends Model {}
    
    /**
     * @property int $id
     * @property int $staff_id
     * @property int $role_id
     * @property float|null $basic_salary
     * @property float|null $total_earning
     * @property float|null $total_deduction
     * @property float|null $gross_salary
     * @property float|null $tax
     * @property float|null $net_salary
     * @property string|null $payroll_month
     * @property string|null $payroll_year
     * @property string|null $payroll_status
     * @property string|null $payment_mode
     * @property Carbon|null $payment_date
     * @property string|null $note
     * @property string|null $bank_name
     * @property string|null $bank_branch_name
     * @property string|null $account_no
     * @property string|null $cheque_no
     * @property int $active_status
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_PayrollEarnDeduce_C|PayrollEarnDeduce[] $payroll_earn_deducs
     * @property-read int $payroll_earn_deducs_count
     * @method HasMany|_IH_PayrollEarnDeduce_QB payroll_earn_deducs()
     * @property Role $role
     * @method BelongsTo|_IH_Role_QB role()
     * @property Staff $staff
     * @method BelongsTo|_IH_Staff_QB staff()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Payroll_QB onWriteConnection()
     * @method _IH_Payroll_QB newQuery()
     * @method static _IH_Payroll_QB on(null|string $connection = null)
     * @method static _IH_Payroll_QB query()
     * @method static _IH_Payroll_QB with(array|string $relations)
     * @method _IH_Payroll_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Payroll_C|Payroll[] all()
     * @ownLinks created_by,\PragmaRX\Google2FALaravel\Tests\Support\User,id|updated_by,\PragmaRX\Google2FALaravel\Tests\Support\User,id|role_id,\Modules\RolePermission\Entities\Role,id
     * @foreignLinks id,\Modules\HumanResource\Entities\PayrollEarnDeduce,payroll_id|id,\Modules\HumanResource\Entities\SmLeaveDeductionInfo,payroll_id
     * @mixin _IH_Payroll_QB
     */
    class Payroll extends Model {}
    
    /**
     * @property int $id
     * @property string|null $type_name
     * @property float|null $amount
     * @property string|null $earn_dedc_type
     * @property int $active_status
     * @property int $loan_status
     * @property int $payroll_id
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property Payroll $payroll
     * @method BelongsTo|_IH_Payroll_QB payroll()
     * @method static _IH_PayrollEarnDeduce_QB onWriteConnection()
     * @method _IH_PayrollEarnDeduce_QB newQuery()
     * @method static _IH_PayrollEarnDeduce_QB on(null|string $connection = null)
     * @method static _IH_PayrollEarnDeduce_QB query()
     * @method static _IH_PayrollEarnDeduce_QB with(array|string $relations)
     * @method _IH_PayrollEarnDeduce_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PayrollEarnDeduce_C|PayrollEarnDeduce[] all()
     * @ownLinks created_by,\PragmaRX\Google2FALaravel\Tests\Support\User,id|updated_by,\PragmaRX\Google2FALaravel\Tests\Support\User,id|payroll_id,\Modules\HumanResource\Entities\Payroll,id
     * @mixin _IH_PayrollEarnDeduce_QB
     */
    class PayrollEarnDeduce extends Model {}
    
    /**
     * @property int $id
     * @property int|null $staff_id
     * @property int|null $payroll_id
     * @property int|null $extra_leave
     * @property int|null $salary_deduct
     * @property string|null $pay_month
     * @property string|null $pay_year
     * @property int|null $active_status
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_SmLeaveDeductionInfo_QB onWriteConnection()
     * @method _IH_SmLeaveDeductionInfo_QB newQuery()
     * @method static _IH_SmLeaveDeductionInfo_QB on(null|string $connection = null)
     * @method static _IH_SmLeaveDeductionInfo_QB query()
     * @method static _IH_SmLeaveDeductionInfo_QB with(array|string $relations)
     * @method _IH_SmLeaveDeductionInfo_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SmLeaveDeductionInfo_C|SmLeaveDeductionInfo[] all()
     * @ownLinks payroll_id,\Modules\HumanResource\Entities\Payroll,id
     * @mixin _IH_SmLeaveDeductionInfo_QB
     */
    class SmLeaveDeductionInfo extends Model {}
    
    /**
     * @property int $id
     * @property string|null $employee_id
     * @property int|null $user_id
     * @property int|null $department_id
     * @property int|null $showroom_id
     * @property int|null $warehouse_id
     * @property string|null $phone
     * @property string|null $bank_name
     * @property string|null $bank_branch_name
     * @property string|null $bank_account_name
     * @property string|null $bank_account_no
     * @property string|null $current_address
     * @property string|null $permanent_address
     * @property string|null $basic_salary
     * @property string|null $employment_type
     * @property float|null $opening_balance
     * @property int $provisional_months
     * @property Carbon|null $date_of_joining
     * @property Carbon|null $date_of_birth
     * @property Carbon|null $leave_applicable_date
     * @property int $carry_forward
     * @property bool $is_carry_active
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @property Department|null $department
     * @method BelongsTo|_IH_Department_QB department()
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property _IH_Payroll_C|Payroll[] $payrolls
     * @property-read int $payrolls_count
     * @method HasMany|_IH_Payroll_QB payrolls()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Staff_QB onWriteConnection()
     * @method _IH_Staff_QB newQuery()
     * @method static _IH_Staff_QB on(null|string $connection = null)
     * @method static _IH_Staff_QB query()
     * @method static _IH_Staff_QB with(array|string $relations)
     * @method _IH_Staff_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Staff_C|Staff[] all()
     * @ownLinks user_id,\PragmaRX\Google2FALaravel\Tests\Support\User,id
     * @mixin _IH_Staff_QB
     */
    class Staff extends Model {}
    
    /**
     * @property int $id
     * @property int $staff_id
     * @property string|null $name
     * @property string|null $documents
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @property Staff $staff
     * @method BelongsTo|_IH_Staff_QB staff()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_StaffDocument_QB onWriteConnection()
     * @method _IH_StaffDocument_QB newQuery()
     * @method static _IH_StaffDocument_QB on(null|string $connection = null)
     * @method static _IH_StaffDocument_QB query()
     * @method static _IH_StaffDocument_QB with(array|string $relations)
     * @method _IH_StaffDocument_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_StaffDocument_C|StaffDocument[] all()
     * @mixin _IH_StaffDocument_QB
     */
    class StaffDocument extends Model {}
    
    /**
     * @property int $id
     * @property string $title
     * @property Carbon $date
     * @property bool $status
     * @property int|null $created_by
     * @property int|null $updated_by
     * @property int $lms_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property LmsInstitute $institute
     * @method BelongsTo|_IH_LmsInstitute_QB institute()
     * @method static _IH_ToDo_QB onWriteConnection()
     * @method _IH_ToDo_QB newQuery()
     * @method static _IH_ToDo_QB on(null|string $connection = null)
     * @method static _IH_ToDo_QB query()
     * @method static _IH_ToDo_QB with(array|string $relations)
     * @method _IH_ToDo_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ToDo_C|ToDo[] all()
     * @mixin _IH_ToDo_QB
     */
    class ToDo extends Model {}
}